' Rollscanner - CIS driver / image capture program (QBASIC)
' ------------------------------------------------
' Version 33. Based on CFG file version of 3 Feb 2003, R Stibbons
' Adds support for double speed scanner hardware KMK July 2003
' Faster version (also reformatted & commented) JRD March 2004
' Debug version KMK
' Dual array 4-Bit version wired for encoder data KMK

' Declarations and defaults
' -------------------------

DECLARE FUNCTION GetLowTickCount&()

DIM cfg$(20)
DIM bytea%(1900)	'reserve memory for byte array
DIM pixa%(3800)         'reserve memory for pixel array 1
DIM pixb%(3800)		'reserve memory for pixal array 2
DIM rtype$(30)          'roll type

    CLS
    FOR x% = 0 TO 25
	READ rtype$(x%)
    NEXT

    Debug% = 0
    ClkDly% = 50
    ClkDly2% = 30
    ClkDly3% = 10

    SCREEN 9
    VIEW PRINT 4 TO 24
    PRINT "CIS SCANNER CONTROL PROGRAM"; ""
    PRINT
    ON ERROR RESUME NEXT
    OPEN "CIS.CFG" FOR INPUT AS #2
    IF ERR = 53 THEN  ' no file
	PRINT "No configuration file has been found"
	GOSUB makecfg
	RUN   '
    END IF

    ON ERROR GOTO 0

    x% = 0
    PRINT "Configuration file details :-": PRINT

    WHILE NOT EOF(2)
	INPUT #2, cfg$(x%)
	PRINT cfg$(x%)
	x% = x% + 1
    WEND
    GOSUB readcfg

    PRINT "ClkDly2="; ClkDly2%
    PRINT "ClkDly3="; ClkDly3%
    PRINT : PRINT

    port1% = port% + 1
    port2% = port% + 2


' Obtain details of roll being scanned
' ------------------------------------
    DO 'loop from nul tempo
jump1:
	INPUT "File name"; f$
	IF UCASE$(f$) = "CFG" THEN
	    PRINT "Configuration file will be deleted.": INPUT "Proceed "; i$
	    IF UCASE$(i$) = "Y" THEN
		CLOSE #2
		KILL "CIS.CFG"
		RUN
	    ELSE
		GOTO jump1
	    END IF
	END IF

	PRINT
	x% = 0
	DO UNTIL UCASE$(RIGHT$(f$, 1)) = UCASE$(RIGHT$(rtype$(x%), 1)) OR x% > 25
	    x% = x% + 1
	LOOP
	IF LEN(rtype$(x%)) < 2 THEN
	    BEEP
	    PRINT "Unrecognised roll type identifier": PRINT
	ELSE
	    PRINT LEFT$(rtype$(x%), LEN(rtype$(x%)) - 1); " roll "; RIGHT$(f$, LEN(f$) - 1): PRINT
	END IF

	DO
	    INPUT "Roll tempo "; i$
	LOOP WHILE VAL(i$) > 180
    LOOP WHILE i$ = "" 'back to filename

    tempo% = VAL(i$)

    IF tprompt% <> 0 THEN INPUT "Title (chars > 32 will be truncated)"; i$
    title$ = LEFT$((i$ + origin$ + SPACE$(32)), 32)

    LpiFactor! = 50 / lpi%

    VIEW PRINT 23 TO 24

    CLS
    PRINT : PRINT "Scanning "; f$
    PRINT "Hit any key to stop scan";


' Create new CIS file and write header details
' --------------------------------------------

    fd$ = "D:" + f$ + ".DBS"
    f$ = "D:" + f$ + ".CIS"
    'fd$ = f$ + ".DBS"
    'f$ =  f$ + ".CIS"
    SHELL "del " + f$

    OPEN f$ FOR BINARY AS #1
    IF Debug% = 1 THEN
	OPEN fd$ FOR OUTPUT AS #3
	FOR x% = 0 TO xt%
	    PRINT #3, cfg$(x%)
	NEXT x%
	PRINT #3, "ClkDly2="; ClkDly2%
	PRINT #3, "ClkDly3="; ClkDly3%
    END IF

    cl% = 15'inital display colour
    x% = 0: y% = 0: z% = 0

    lc& = 0'              Line count

    FOR x% = 1 TO 32
	D$ = MID$(title$, x%, 1)
	PUT #1, , D$           'store the string
    NEXT
    PUT #1, , z%'           spare
    PUT #1, , statword% '   status word
    PUT #1, , vsep%'        twin array vertical separation
    PUT #1, , dpi%'         array dpi
    PUT #1, , w%'           scan width
    PUT #1, , co%'          twin array changeover
    PUT #1, , tempo%'       roll tempo
    PUT #1, , lpi%'         scanner lpi
    PUT #1, , lc&'          number of lines in this file

' Scannning loop starts here
' --------------------------
' Scanner inputs to PC
'port1% b3 (8)   Pin 15 Bass Data 1
'port1% b4 (16)  Pin 13 Bass Data 2
'port1% b5 (32)  Pin 12 Treble Data 1
'port1% b6 (64)  Pin 10 Roll End
'port1% b7 (128) Pin 11 Treble Data 2 (inverted by port)


' Outputs from PC to scanner
'port2% b0 (1)   Pin 1  Stepper Advance
'port2% b1 (2)   Pin 14 Scanner On(inverted by port)
'port2% b2 (4)   Pin 16 CIS Clock (inverted by port)
'port2% b3 (8)   Pin 17 CIS Transfer

    dw1& = GetLowTickCount& + 1
    while dw1& > GetLowTickCount&
    wend
    StartScan& = dw1&
    LastTime& = dw1&

tloop1:
    OUT port2%, 6   'turn on scanner and keep bit(1) HI throughout
    FOR z% = 0 TO (ClkDly% * 2): NEXT

    IF twin% = 1 THEN
	GOTO Loop4L
    END IF

'###########################################################################
loop1:             'Top of main loop MK3
   IF sd% = 1 THEN ' Check if single or double speed
	GOTO loop2
    END IF

    ' Single Speed CIS capture
    ' ------------------------

    ' Enable CIS image transfer. CIS Clock must go LO-HI while Transfer is HI.
    OUT port2%, 14                   ' Transfer HI  (1110)
    FOR z% = 0 TO ClkDly%: NEXT
    OUT port2%, 10                   ' Clock LO     (1010)
    OUT port2%, 14                   ' Clock HI     (1110)
    OUT port2%, 6                    ' Transfer LO  (0110)

    ' CIS readout loop, 1 pixel per clock cycle (w% cycles).
    ' Store Data 1 (bit 3) directly.
'###########################################################################
    FOR x% = 0 TO w%
	 OUT port2%, 2                 ' Clock LO     (0010)
	 OUT port2%, 6                 ' Clock HI     (0110)
	 pixa%(x%) = (INP(port1%) AND 8) / 8
      NEXT x%

    NextTime& = GetLowTickCount&
    RelTimeR% = NextTime& - LastTime&
    FOR z% = 0 TO ClkDly%: NEXT
 
    GOTO ProcessLine

' Note on speed-doubled hardware. This generates a CIS clock pulse for every change
' of clock state sent from here. The duration of the CIS pulse is set in the hardware.
' A second, slightly-delayed, hardware-set clock controls the shift register that packs
' two CIS bits for transfer to the PC. The software must be tuned to match - too fast
' and no image will be received because the port is read before the data is ready.
' The speed-doubling arises from sending 2 bits per clock pulse - in reality, the
' need for delays reduces the effective speedup.

'###########################################################################
loop2:             'Top of main loop MK3a

    ' Double Speed CIS capture
    ' ------------------------
    ' Has a different sequence of clock states than for single speed because
    ' hardware timing is more critical (must allow setting of 2-bit shift
    ' register etc on the Mk3a board).

    ' Enable CIS image transfer. Initial bit state is (0010), ie Clock LO
    OUT port2%, 10 ' clock (b2) HI (clock must fire during txfr HI)
    FOR z% = 0 TO 5: NEXT
    OUT port2%, 2 ' transfer (b3) LO, clock (b3) LO, scanner on (b1) LO
    c% = 0: ca% = 0: cb% = 0: p1% = 0: A% = 0: p2% = 0: B% = 0: f% = 0 'initialize some variables

'###########################################################################
    FOR x% = 0 TO w% / 2 '           Main CIS readout loop

	OUT port2%, 6               'clock Hi
	pixa%(c%) = (bytea%(X%) AND 16) \ 16
	c% = c% + 1
	pixa%(c%) = (bytea%(X%) AND 8) \ 8
	c% = c% + 1
        FOR z% = 0 TO ClkDly%: NEXT
	OUT port2%, 2               'clock LO
        'FOR z% = 0 TO ClkDly3%: NEXT
	bytea%(x%) = INP(port1%)    'Data 1 is port1% b(3)
                                    'Data 2 is port1% b(4) get them both
    NEXT x%                         ' Back to top of readout loop
                                    ' See how tight it is !

    pixa%(c%) = (bytea%(X%) AND 16) \ 16
    c% = c% + 1
    pixa%(c%) = (bytea%(X%) AND 8) \ 8

    NextTime& = GetLowTickCount&
    RelTimeR% = NextTime& - LastTime&

    'FOR z% = 0 TO ClkDly%: NEXT

    GOTO ProcessLine

'###########################################################################
Loop4L:             'Top of main loop MK3b Dual Array 4 Bit

    'fire clock and transfer
    OUT port2%, 10 ' clock (b2) HI (clock must fire during txfr HI)
    FOR z% = 0 TO 5: NEXT
    OUT port2%, 2 ' transfer (b3) LO, clock (b3) LO, scanner on (b1) LO
    c% = 0: ca% = 0: cb% = 0: p1% = 0: A% = 0: p2% = 0: B% = 0: f% = 0 'initialize some variables

'###########################################################################
    FOR x% = 0 TO w% / 2 '           Main CIS readout loop

	OUT port2%, 6               'clock Hi
	pixa%(c%) = (bytea%(X%) AND 16) \ 16
	pixb%(c%) = (bytea%(X%) AND 64) \ 64
	c% = c% + 1
	pixa%(c%) = (bytea%(X%) AND 8) \ 8
	pixb%(c%) = (bytea%(X%) AND 32) \ 32
	c% = c% + 1
        FOR z% = 0 TO ClkDly%: NEXT
	OUT port2%, 2               'clock LO
        FOR z% = 0 TO ClkDly3%: NEXT
	bytea%(x%) = INP(port1%)    'Data 1 is port1% b(3)
                                    'Data 2 is port1% b(4) get them both
                                    'Data 3 is port1% b(5)
                                    'Data 4 is port1% b(7) get them both
    NEXT x%                         ' Back to top of readout loop
                                    ' See how tight it is !

    pixa%(c%) = (bytea%(X%) AND 16) \ 16
    pixb%(c%) = (bytea%(X%) AND 64) \ 64
    c% = c% + 1
    pixa%(c%) = (bytea%(X%) AND 8) \ 8
    pixb%(c%) = (bytea%(X%) AND 32) \ 32

    NextTime& = GetLowTickCount&
    RelTimeR% = NextTime& - LastTime&

    FOR z% = 0 TO ClkDly%: NEXT
    GOTO ProcessTwinLine

ProcessLine:
'#########################################################################
    pixa%(0) = 0'    Set first pixel to 0 regardless
		'    The data is now in memory array pix%(a%)

   ' Get clock and encoder values
   ' ----------------------------

    e% = INP(port1%) AND 160  'get encoder & RTC - port1% b6 & b7
    r% = e% AND 32 '16 clock ticks per sec
    IF r% <> rold% THEN
	rcount& = rcount& + 1'count changes of state of RTC
	rold% = r%
    END IF
    OUT port2%, 7' stepper advance LO Clock HI

    lc& = lc& + 1         '            Increment line counter

    ' Perform run length compression of pixel data and save to disk
    ' -------------------------------------------------------------
    ' The data is in array pixa%. Now compress it and save to disc.
    ' Variable c% steps through the pixels array in memory and variable d%
    ' counts succeeding bytes which are the same.  When 'ones' change to 'noughts'
    ' or vice versa, the value in d% is stored on the disc.

    C% = 0
    D% = 1

    pixa%(0) = 0                      ' Set first pixel to 0 regardless

loop5:                                '-- should replace following logic with loops...
    C% = C% + 1

    IF C% = w% THEN GOTO loop6         ' End when end of array is reached

    ' If this pixel is same as the one before, increment d% and get the next one.
    IF pixa%(C%) = pixa%(C% - 1) THEN
	D% = D% + 1:
	GOTO loop5
    END IF

loop6:                                ' There has been a change of state so store
    PUT #1, , D%: D% = 1               ' the value in d%

    PRESET (C% / 7 + 20, y%), cl%      ' Update screen display
    IF C% < w% THEN GOTO loop5         ' Continue unless at end of array

    PUT #1, , e%'    save encoder and realtime clock

    ' Update display and perform end-of-line checks
    ' ---------------------------------------------

    PRESET ((e% AND 32) / 2 + 550, y%), 4    ' Display RTC
    PRESET ((e% AND 128) / 8 + 570, y%), 5   ' Display encoder
    y% = y% + 1
    IF y% = 305 THEN y% = 0
    LINE (0, y%)-(630, y%), 0                ' Blank next line to avoid screen clear

    'ik$ = INKEY$
    'IF ik$ = CHR$(32) THEN GOTO FINISH
    'IF ik$ = "." THEN
	'ClkDly% = ClkDly% + 5
	'ClkDly2% = ClkDly% * 0.6
	'ClkDly3% = ClkDly% * 0.2
	'PRINT ClkDly%
    'END IF

    ' Exit only if key pressed or end-of-roll detector activated
    IF INKEY$ <> "" THEN GOTO FINISH
    IF rend% <> 0 AND ((INP(port1%) AND 64) = 64) THEN GOTO FINISH

    IF INKEY$ <> "" THEN GOTO FINISH
    IF rend% <> 0 AND ((INP(port1%) AND 64) = 64) THEN GOTO FINISH'  if end of roll switch is on or

    NextTime& = GetLowTickCount&
    RelTime% = NextTime& - LastTime&
    LastTime& = NextTime&
    IF Debug% = 1 THEN
        PRINT #3, RelTime%; RelTimeR%
    END IF
    GOTO loop1'     Back to top unless user has pressed a key

ProcessTwinLine:
'#########################################################################
    pixa%(0) = 0'    Set first pixel to 0 regardless
    pixb%(0) = 0'    Set first pixel to 0 regardless
'             The data is now in memory arrays pix%(a%)

    e% = INP(port1%) AND 128  'get encoder - port1% b7
    l% = e% AND 128
    IF l% <> lold% THEN
        lcount& = lcount& + 1'count changes of state of RTC
        lold% = l%
    END IF
    OUT port2%, 7'stepper advance HI Clock LO

    lc& = lc& + 1         '            Increment line counter

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'Compress the data and save it to disc

'Pack & save A array
'Variable c% steps through the pixels array in memory and variable d%
'counts succeeding bytes which are the same.  When ones change to noughts
'or vice versa, the value in d% is stored in the disc.

    c% = 0: d% = 1'    Set initial values
loop7L:
    c% = c% + 1

    IF c% = W% THEN GOTO loop8L '  w% is width of array.  End if C% has reached it
    'pack and save A array data
    IF pixa%(c%) = pixa%(c% - 1) THEN d% = d% + 1: GOTO loop7L' If this pixel is
'         same as the one before, increment d% and get the next one.

loop8L: '                     There has been a change of state so store
    PUT #1, , d%: d% = 1       ' the value in d%
    PRESET (c% \ 5 + 20, y%), 14 ' display on screen
    IF c% < W% THEN GOTO loop7L ' Get some more unless at end of array

    'pack & save B array data  - works identically to A
    c% = 0: d% = 1
loop9L:
    c% = c% + 1

    IF c% = W% THEN GOTO loop10L
    IF pixb%(c%) = pixb%(c% - 1) THEN d% = d% + 1: GOTO loop9L

loop10L:
    PUT #1, , d%: d% = 1
    PRESET (c% \ 5 + 20, y%), 10 ' display on screen
    IF c% < W% THEN GOTO loop9L

'The data in the pixel arrays has been compressed and put on the disc
'All the data from both arrays is saved.  The delay and stitching process is carried out
'in the SCN processing program.  This makes it possible to adjust the settings
'at a later stage
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

    PUT #1, , e%'    save encoder
    PRESET ((e% AND 128) \ 8 + 570, y%), 5'display encoder
    y% = y% + 1
    IF y% = 305 THEN y% = 0
    LINE (0, y%)-(630, y%), 0  'blank next line to avoid screen clear

    ik$ = INKEY$
    IF ik$ = CHR$(32) THEN GOTO FINISH
    IF ik$ = "." THEN
	ClkDly% = ClkDly% + 5
	ClkDly2% = ClkDly% * 0.6
	ClkDly3% = ClkDly% * 0.2
	PRINT ClkDly%
    END IF
    IF ik$ = "," THEN
	ClkDly% = ClkDly% - 5
	ClkDly2% = ClkDly% * 0.6
	ClkDly3% = ClkDly% * 0.2
	PRINT ClkDly%
    END IF

    IF INKEY$ <> "" THEN GOTO FINISH

    NextTime& = GetLowTickCount&
    RelTime% = NextTime& - LastTime&
    LastTime& = NextTime&
    IF Debug% = 1 THEN
        PRINT #3, RelTime%; RelTimeR%
    END IF
    GOTO loop4L'     Back to top unless user has pressed a key

FINISH:

    'End of run
    OUT port2%, 0         'Switch off scanner
    PUT #1, 49, lc&'       Save final line count

    ElapsedTime& = GetLowTickCount& - StartScan&
    IF Debug% = 1 THEN
        PRINT #3, "Time of scan = "; ElapsedTime& / 10000
        PRINT #3, "Lines Read = "; lc&; " at "; lc& / (ElapsedTime& / 10000); " lps"
    END IF
    PRINT "Lines "; lc&; " Time"; ElapsedTime& / 10000; " at Lps "; (lc& / (ElapsedTime& / 10000))

    CLOSE

    INPUT " Hit any key to exit ", i$
    CLS
    END

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'SUBROUTINES
'build config file
makecfg:

    DO
	x% = 0
	INPUT "Port Number in hex (e.g. 278)"; i$
	port% = VAL("&H" + i$)
    LOOP WHILE port% < 100 OR port% > 4000

'
    INPUT "Origin (32 chars max)"; i$
    origin$ = LEFT$(i$, 34)

    DO
	INPUT "Prompt for title input "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN tprompt% = 1

'
    DO
	PRINT : PRINT "Scanner type ?"
	PRINT : PRINT "1 = Free run"
	PRINT "2 = Position Encoder"
	PRINT "3 = Shaft Encoder"
	PRINT "4 = Stepper"
	INPUT i%
    LOOP WHILE i% < 1 OR i% > 4
    stype% = i%

    DO
	INPUT "Speed Doubling Hardware "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN sd% = 1

    DO
	INPUT "Twin array "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN twin% = 1

    DO
	INPUT "BiColor "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN BiColor% = 1

    div% = 0
    IF stype% = 2 OR stype% = 3 THEN
	DO
	    INPUT "Encoder division ratio (2^n) "; i%
	LOOP WHILE i% < 0 AND i% > 16
	div% = i%
    END IF

    HorzReverse% = 0
    DO
	INPUT "Reverse Bass-Treble "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN HorzReverse% = 1

    VertReverse% = 0
    DO
	INPUT "Reverse Scan "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN VertReverse% = 1

    IF twin% <> 0 THEN 'twin array parameters
	DO
	    INPUT "Vertical separation of arrays in inches times 1,000"; i%
	LOOP WHILE i% < 0 OR i% > 10000
	vsep% = i%
	IF vsep% <> 0 THEN
	    DO
 	        INPUT "Changeover point between arrays "; i%
 	    LOOP WHILE i% < 100 OR i% > 5000
 	END IF
	co% = i%
    END IF

    DO
	INPUT "Array dots per inch "; i%
    LOOP WHILE i% < 50 OR i% > 500
    dpi% = i%

    DO
	INPUT "Array width "; i%
    LOOP WHILE i% < 200 OR i% > 8000
    w% = i%

    DO
	INPUT "Stepper or encoder lines per inch "; i%
    LOOP WHILE i% < 10 OR i% > 500
    lpi% = i%

    DO
	INPUT "Enable Roll End Detectors "; i$
	i$ = UCASE$(LEFT$(i$, 1))
    LOOP WHILE i$ <> "Y" AND i$ <> "N"
    IF i$ = "Y" THEN rend% = 1

    ON ERROR RESUME NEXT
    CLOSE #2
    KILL "CIS.CFG"


    OPEN "CIS.CFG" FOR OUTPUT AS #2
    PRINT #2, "Port= " + HEX$(port%)
    PRINT #2, "Origin= " + origin$
    PRINT #2, "Prompt=" + STR$(tprompt%)
    PRINT #2, "Type=" + STR$(stype%)
    PRINT #2, "Speed Doubling=" + STR$(sd%)
    PRINT #2, "Twin Array=" + STR$(twin%)
    PRINT #2, "VSeparation=" + STR$(vsep%)
    PRINT #2, "Changeover=" + STR$(co%)
    PRINT #2, "Bi-Colour=" + STR$(BiColor%)
    PRINT #2, "Division=" + STR$(div%)
    PRINT #2, "Mirror Image=" + STR$(HorzReverse%)
    PRINT #2, "Reverse Scan=" + STR$(VertReverse%)
    PRINT #2, "DPI=" + STR$(dpi%)
    PRINT #2, "Width=" + STR$(w%)
    PRINT #2, "LPI=" + STR$(lpi%)
    PRINT #2, "Roll End Detectors=" + STR$(rend%)
    PRINT #2, "ClkDly=" + STR$(ClkDly%)
    PRINT #2, "Debug=" + STR$(0)

    CLOSE #2

readcfg: 'interprets cfg file data
    x% = 0
    DO UNTIL cfg$(x%) = ""
	IF LEFT$(cfg$(x%), 6) = "Port= " THEN port% = VAL("&H" + RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 6))
	IF LEFT$(cfg$(x%), 8) = "Origin= " THEN origin$ = RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 7)
	IF LEFT$(cfg$(x%), 7) = "Prompt=" THEN tprompt% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 5) = "Type=" THEN stype% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 5))
	IF LEFT$(cfg$(x%), 15) = "Speed Doubling=" THEN sd% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 11) = "Twin Array=" THEN twin% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 12) = "VSeparation=" THEN vsep% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 12))
	IF LEFT$(cfg$(x%), 11) = "Changeover=" THEN co% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 11))
	IF LEFT$(cfg$(x%), 10) = "Bi-Colour=" THEN BiColor% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 9) = "Division=" THEN div% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 9))
	IF LEFT$(cfg$(x%), 13) = "Mirror Image=" THEN HorzReverse% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 13) = "Reverse Scan=" THEN VertReverse% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 4) = "DPI=" THEN dpi% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 4))
	IF LEFT$(cfg$(x%), 6) = "Width=" THEN w% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 6))
	IF LEFT$(cfg$(x%), 4) = "LPI=" THEN lpi% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 4))
	IF LEFT$(cfg$(x%), 19) = "Roll End Detectors=" THEN rend% = VAL(RIGHT$(cfg$(x%), 1))
	IF LEFT$(cfg$(x%), 7) = "ClkDly=" THEN
	ClkDly% = VAL(RIGHT$(cfg$(x%), LEN(cfg$(x%)) - 7))
	ClkDly2% = ClkDly% * 0.6
	ClkDly3% = ClkDly% * 0.2
    END IF
    IF LEFT$(cfg$(x%), 6) = "Debug=" THEN Debug% = VAL(RIGHT$(cfg$(x%), 1))
    x% = x% + 1
    LOOP 
    xt% = x%
    statword% = stype% + 16 * sd% + 32 * twin% + 64 * BiColor% + 256 * div% + 4096 * HorzReverse% + 8192 * VertReverse%
    tpireal% = lpi%
    IF stype% = 2 THEN 'encoder BT scanner
	divreal% = 2 ^ div%
	tpireal% = (lpi% / divreal%)
    END IF
    RETURN


DATA Ampico AA,Ampico BB,C,DuoArt D,E,F,Green Welte G,H,Artrio Angelus I,J,K
DATA L,M,Nickelodeon N, Organ O,P,Q,Red Welte R,Standard 88 S
DATA Triphonola T,U,V,Welte Licensee W,X,Y,Z

