'Temporary Universal version for the group 26 Dec 2002 - and still sober !
'DuoArt lag and treble boost added 12 Nov 00  search for "FFFFFF"
'Added Welte routines 2004
'New Version 2005 KMK

COMMON SHARED Debug%
DECLARE SUB midiproc (filename AS STRING, sd AS STRING, dd AS STRING, typ AS STRING, fcount AS SINGLE, alag AS SINGLE, tlag AS SINGLE, uplift AS SINGLE, timeconst AS INTEGER)

    DataIn$ = COMMAND$

    IF DataIn$ = "" THEN
	GOTO NormalRun
    END IF

    Debug% = INSTR(DataIn$, "/D")
    IF Debug% THEN
	DataIn$ = RTRIM$(LEFT$(DataIn$, Debug% - 1))
    END IF

    a% = INSTR(DataIn$, "/")

    IF a% = 0 THEN
	FileName$ = RTRIM$(DataIn$)
	sys% = 6
    ELSE
	FileName$ = RTRIM$(LEFT$(DataIn$, a% - 1))
	sys% = VAL(RIGHT$(DataIn$, LEN(DataIn$) - a%))
    END IF

    IF INSTR(FileName$, ".") <> 0 THEN
	FileName$ = LEFT$(FileName$, LEN(FileName$) - 4)
    END IF

NormalRun:
'Specify source and destination directories~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sd$ = ""                  'source directory
dd$ = ""                  'destination directory
'sd$ = "c:\scans\"        'source directory
'dd$ = "c:\scans\"        'destination directory

SHELL "del " + sd$ + "temp.*"

CLS : PRINT : PRINT : PRINT

PRINT
PRINT "                SCN to MID BULK CONVERTOR"
PRINT "                ~~~~~~~~~~~~~~~~~~~~~~~~~"
PRINT "                    UNIVERSAL VERSION"
PRINT "                    ~~~~~~~~~~~~~~~"
PRINT "For correct operation, filenames must end with one of"
PRINT "the following letters."
PRINT
PRINT "               A    Ampico"
PRINT "               D    Duo Art"
PRINT "               I    Artrio Angelus"
PRINT "               R    RedWelte"
PRINT "               W    Welte"
PRINT : PRINT "All other cases will be treated as Standard 88 note"
PRINT : PRINT
PRINT : PRINT "Specified directories must exist"
PRINT : PRINT "Press Return to use defaults"
PRINT
PRINT "Source Directory (default is "; sd$; ")"
INPUT D$
IF D$ <> "" THEN sd$ = D$
PRINT : PRINT "Destination Directory (default is "; dd$; ")"
INPUT D$
IF D$ <> "" THEN dd$ = D$
'INPUT "Accompaniment Lag in  milliseconds (200)"; alag
IF alag = 0 THEN alag = 200
'INPUT "Theme lag in milliseconds (200)", tlag
IF tlag = 0 THEN tlag = 200
'INPUT "Uplift Factor (8)", uplift
IF uplift = 0 THEN uplift = 8
'INPUT "Time Constant (85)", timeconst%
IF timeconst% = 0 THEN timeconst% = 85

GetType:
Outtyp$ = "B"
PRINT : PRINT "MIDI (M) or EMIDI (E) Output (default is "; Outtyp$; ")"
INPUT D$
IF D$ <> "" THEN Outtyp$ = UCASE$(D$)
IF Outtyp$ <> "M" AND Outtyp$ <> "E" AND Outtyp$ <> "B" THEN
 GOTO GetType
END IF
SHELL "echo off"
SHELL "del filelist.txt"
SHELL "del errorlog.txt"            'create empty error file
OPEN "errorlog.txt" FOR OUTPUT AS #7
CLOSE #7
SHELL "echo on"
SHELL "dir " + sd$ + "*.scn /b /ON > filelist.txt"
' .scn filenames are now in 'filelist.txt'

IF FileName$ <> "" THEN
    CALL midiproc(filename$, sd$, dd$, Outtyp$, fcount, alag, tlag, uplift, timeconst%)
    GOTO Quit
END IF

OPEN "filelist.txt" FOR INPUT AS #5
'count number of .scn files into fcount
fcount = 0
WHILE NOT EOF(5)
LINE INPUT #5, f$
IF UCASE$(RIGHT$(f$, 3)) = "SCN" THEN PRINT f$, : fcount = fcount + 1: IF LEN(f$) > 12 THEN STOP
WEND

SEEK #5, 1
'get first filename
WHILE fcount > 0
LINE INPUT #5, f$
IF UCASE$(RIGHT$(f$, 3)) <> "SCN" THEN GOTO skipa
af$ = LEFT$(f$, LEN(f$) - 4)
filename$ = af$

CALL midiproc(filename$, sd$, dd$, Outtyp$, fcount, alag, tlag, uplift, timeconst%)
fcount = fcount - 1
skipa:

WEND
Quit:

CLOSE
END


filedata:  'MIDI setup data & meta events
DATA 77,84,104,100,0,0,0,6,0,1,0,2,0,200,256
DATA 0,255,88,4,4,2,24,8,0,255,81,3,7,161,32,0,255,47,0,256
DATA 77,84,104,100,0,0,0,6,0,1,0,2,0,200,256
DATA 0,255,88,4,4,2,24,8,0,255,81,3,7,161,32,0,255,47,0,256

'data for DuoArt lookup table
accpt:
DATA 32,38,44,48,52,56,60,64,67,70,75,80,84,88,94,98
th:
DATA 33,39,44,49,53,57,61,65,68,71,76,81,85,89,95,99

'
SUB midiproc (filename AS STRING, sd AS STRING, dd AS STRING, Outtyp AS STRING, fcount AS SINGLE, alag AS SINGLE, tlag AS SINGLE, uplift AS SINGLE, timeconst AS INTEGER)
'
'DA lookup table version 22 March 2000
CLS
PRINT : PRINT : PRINT : PRINT
PRINT "                    SCN to MIDI PROCESSOR"

DIM zap%(101)   'Array used for web remover "stalagmite" display
DIM spk%(101)   ' ditto for speck remover
DIM cat$(5)     'Catalogue array
DIM A$(10)      'ANN array
DIM accpwr%(16)
DIM thpwr%(16)
RESTORE accpt:
FOR x% = 0 TO 15
READ accpwr%(x%)
NEXT
RESTORE th:
FOR x% = 0 TO 15
READ thpwr%(x%)
NEXT
'some variables

zap% = 255      'note value used to kill unwanted events
vmin% = 45      'minimum velocity allowed in expression algorithm
vmax% = 90      'maximum velocity allowed in expression algorithm
vHI% = 0        'starting value used in finding max velocity of current file
vLO% = 128      'starting value used in finding min velocity of current file
p1& = 1         'file pointer used by web remover
p2& = 1         'file pointer used by web remover
dlm& = 0        'SCN file de-limiter
evnt& = 0      'number of events in SCN file
tempo% = 0      'marked roll tempo
tempadjust! = 1 'real number value used to adjust distance variables
et& = 0         'line number in SCN file
en% = 0         'note num in SCN file, bit 7 set if note on, clear if note off
lpi% = 0        'scanner line per inch
f$ = ""                    'filename without path or extension
sf$ = ""                   'source filename with path
dfm$ = ""                  'MIDI destination filename
dfe$ = ""                  'E-roll destination filename
UseDyn% = 0

SHELL "del " + sd$ + "temp.*"'  delete any leftover temp file

f$ = LEFT$(filename$, 8)          'truncate filename to eight chars max
typ$ = UCASE$(RIGHT$(f$, 1))

sf$ = sd$ + f$ + ".scn"
sfd$ = sd$ + f$ + ".dyn"

dfm$ = dd$ + f$ + ".mid"   'MIDI destination filename
dfe$ = dd$ + f$ + "e.mid"  'E-roll destination filename

PRINT : PRINT

FOR x% = 1 TO 4: cat$(x%) = "": NEXT

SHELL "copy " + sf$ + " " + sd$ + "temp.scn"' copy SCN file to temp storage

' Opens the files for read/write acccess

OPEN sd$ + "temp.not" FOR BINARY AS #2
OPEN sd$ + "temp.scn" FOR BINARY AS #3
IF LEN(DIR$(sfd$)) <> 0 THEN
    UseDyn% = 1
    OPEN sfd$ FOR BINARY AS #4
END IF

'########## skip empty files

IF LOF(3) < 20 THEN
 OPEN "errorlog.txt" FOR APPEND AS #7
 D$ = "No data in " + sf$
 PRINT #7, D$
 CLOSE #7
 GOTO wayout
END IF


'Various parameters are hung on the end of the file.  They will be moved into
'a proper header in the next major revision.
'The final event is 21 bytes in from the end of the file
'It is read here and printed purely as a debug aid
'After the final event comes the number 1000000 as a delimiter

GET #3, LOF(3) - 21, et& ' final line number in file
GET #3, , en%            ' final note in file
GET #3, , dlm&           ' delimiter
GET #3, , sysnum%        ' System number but ignored here
GET #3, , tempo%         ' Roll tempo
GET #3, , lpi%           ' Scanner lpi
GET #3, , x%             ' Spare
GET #3, , evnt&          ' Total number of events in this file

sysnum% = 3'DA only
' ****************** skip dud files
IF dlm& <> 1000000 THEN
 OPEN "errorlog.txt" FOR APPEND AS #7
 D$ = "Invalid file format in " + sf$
 PRINT #7, D$
 CLOSE #7
 GOTO wayout
END IF

IF tempo% = 0 THEN
 OPEN "errorlog.txt" FOR APPEND AS #7
 D$ = "Tempo" + STR$(tempo%) + " in " + sf$
 PRINT #7, D$
 CLOSE #7
 GOTO wayout
END IF


nmax% = 13 * lpi% / 180  'was 15 then 10 Note max web width                    'SO FAR THESE VALUES
pmax% = 25 * lpi% / 180  'was 25 Pedal/expression track max web width  'SEEM TO MAKE VERY
tmax% = 4 * lpi% / 180   'was 9 Theme track max web width             'GOOD MUSIC, VERY
notele% = 0     'note leading edge correction for valve lag
notete% = 0     'note trailing edge correction for valve lag
daele% = -48 * lpi% / 180'Duo Art expression leading edge =0.275 inches       'CLEAR AND SHARP ACCENTS
daete% = -32 * lpi% / 180'Duo Art expression trailing edge= .166 - .07 = .096 inches
datle% = -5 * lpi% / 180 'was -5 Duo Art theme leading edge
datte% = 3 * lpi% / 180 'was 3 Duo Art theme trailing edge      'JUST IN CASE FOR MILNE ROLLS
dple% = 0 * lpi% / 180  'was -6 Damper pedal leading edge         'THESE WERE TOO HIGH
dpte% = 0 * lpi% / 180   'was 6 Damper pedal trailing edge
tuc = .4             'Takeup spool build compensation
speck% = 10 * lpi% / 180 'Maximum speck size
copy$ = ""
author$ = ""
einstruction$ = ""
minstruction$ = "Roll expression/accent tracks, where present, converted to MIDI velocties."
 

' Print file details on screen
PRINT
PRINT "No of scanner lines "; et&; "  Final event "; en%
PRINT "Tempo "; tempo%
PRINT "Scanner step rate "; lpi%;
PRINT "  Number of scan events "; evnt&
PRINT : PRINT "The following parameters are set to the values shown :-":
PRINT "DA expression"; TAB(33); "Leading edge"; daele%; TAB(50); "Trailing edge "; daete%
PRINT "DA theme"; TAB(33); "Leading edge"; datle%; TAB(50); "Trailing edge "; datte%
PRINT "Damper pedal"; TAB(33); "Leading edge"; dple%; TAB(50); "Trailing edge "; dpte%
PRINT "Note web width                 "; nmax%
PRINT "Pedal/expression web width     "; pmax%
PRINT "Theme web width                "; tmax%
PRINT "Take up build comp in % per ft "; tuc
PRINT "Maximum speck size             "; speck%
PRINT "Copyright string               "; copy$
PRINT
PRINT "Source filename                "; sf$

title$ = cat$(2) + " " + cat$(3) + " " + cat$(4)
IF cat$(1) = "" THEN title$ = "" + f$
PRINT "Title "; title$
einstrument$ = "Trackerbar Image:LPI" + STR$(lpi%) + ":Tempo " + STR$(tempo%) + ": " + DATE$
minstrument$ = "Standard MIDI:LPI" + STR$(lpi%) + ":Tempo " + STR$(tempo%) + ": " + DATE$
INPUT "Press any key to continue "; i$
CLS

PRINT
IF tempo% = 0 THEN INPUT "Marked roll tempo "; tempo%


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'SCN FILE PROCESSING STARTS HERE

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
tempjump:
SCREEN 9
VIEW PRINT 20 TO 24
SEEK (2), 1'    reset file pointers
SEEK (3), 1
FOR x% = 0 TO 100'      draw ruler at bottom of screen
IF x% MOD 10 THEN PRESET (x% * 6, 302), 5 ELSE PSET (x% * 6, 302), 9
NEXT
PRESET (24, 304), 7: PRESET (594, 304), 7' draw damper & soft pedal markers

'remove webbing
PRINT "Removing webbing (red) and specks (cyan)"
PRINT "Processing "; filename$; "  "; fcount - 1; "more files to process."
p1& = 1 '       set file pointer to start of file

mainloop1:
p2& = p1&                          ' set search ahead pointer to main pointer
GET #3, p1&, et&                   ' get a line number
IF p1& = 1000000 THEN GOTO onw1    ' end of file ? if yes, exit
GET #3, , en%                      ' get a note
IF en% = 255 THEN GOTO nextevent   ' already zapped - skip to next
IF en% > 127 THEN GOTO nextevent   ' web will always start with "note off" event

'  if we get here it means we have found a "note off" event and we need to
'  set the web width parameters appropriately
webwidth% = nmax%                                   ' note web width
IF ((en% < 11) OR (en% > 90)) AND sysnum% = 3 THEN webwidth% = pmax%
                                     'if Duo-Art AND pedal/expression tracks
IF (en% = 6) OR (en% = 95) THEN webwidth% = tmax%   ' theme tracks

' now search ahead through file using pointer p2& to find a matching "note on"
look3:
p2& = p2& + 6: IF p2& > evnt& * 6 THEN GOTO nextw ' search ptr at end of file ? - exit

GET #3, p2&, et1&                   ' get next event in file
GET #3, , en1%                      ' get associated note

'Wanted and unwanted events might have the same line number so the next test
'checks to see if the search window has been exceeded.
IF et1& - et& > webwidth% THEN GOTO nextw' is the difference in line numbers
'                                           greater than the web window ?

IF (en1% - 128) <> en% THEN GOTO look3  ' loop until you find a matching "note on"

PUT #3, p1& + 4, zap%  ' if it gets here it means these events were the same
PUT #3, p2& + 4, zap%  ' note and within the webwidth window i.e. a web
'                        therefore, zap both

zap%(en%) = zap%(en%) + 1          ' add 1 to the display array
PRESET (en% * 6, 303 - zap%(en%)), 4' and draw "stalagmites"

'NEW NEW NEW 02/06/99
GOTO nextevent
nextw:

' SPECK REMOVER
' we are still in the web/speck processing loop looking at a "note off"
' we now need to see if this event pair has an excessively short duration

p2& = p1&        ' reset search pointer to main pointer
IF (en% = 134) OR (en% = 223) THEN GOTO nextevent ' theme "note ons"  - skip
IF (en% = 6) OR (en% = 95) THEN GOTO nextevent    ' theme "note offs" - skip
look1:
p2& = p2& - 6: IF p2& < 1 THEN GOTO nextevent' search ptr at start of file ? - exit

GET #3, p2&, et1&                      ' get event at search pointer
GET #3, , en1%
IF et& - et1& > speck% THEN GOTO nextevent 'duration > window ? if yes, move on
IF en1% <> en% + 128 THEN GOTO look1 ' matching "note on" ? - if not, get next
'PRINT et& - et1&;
PUT #3, p1& + 4, zap%                ' zap event at main pointer (note on)
PUT #3, p2& + 4, zap%                ' zap event at search pointer (note off)
spk%(en%) = spk%(en%) + 1          ' add 1 to display array
PRESET (en% * 6 + 1, 303 - spk%(en%)), 3' draw pretty picture

nextevent:
'IF p1& MOD 600 = 1 THEN PRINT p1& \ 6
p1& = p1& + 6
IF p1& < LOF(3) - 12 THEN GOTO mainloop1

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@

 'shift events
'PRINT "begin shifting events"

onw1:
SEEK (2), 1
SEEK (3), 1
evnt& = 0
loop5:
GET #3, , et&
GET #3, , en%
IF et& = 1000000 THEN GOTO skip6

'decide which roll type by checking letter on end of filename
'if not DuoArt, skip the timing shifter
IF UCASE$(RIGHT$(f$, 1)) <> "D" THEN GOTO notDA

IF (en% > 134) AND (en% < 139) THEN et& = et& + daele% 'shift bass exp tracks
IF (en% > 218) AND (en% < 223) THEN et& = et& + daele% 'shift treb exp tracks
IF en% = 134 THEN et& = et& + datle% 'shift bass themes
IF en% = 223 THEN et& = et& + datle% 'shift treb themes
IF (en% > 6) AND (en% < 11) THEN et& = et& + daete% 'shift bass exp tracks
IF (en% > 90) AND (en% < 95) THEN et& = et& + daete%'shift treb exp tracks
IF en% = 6 THEN et& = et& + datte% 'shift bass themes
IF en% = 95 THEN et& = et& + datte% 'shift treb themes

notDA:
IF en% = 132 THEN et& = et& + dple%' damper pedal has gone on, add negative inc to advance timing
IF en% = 4 THEN et& = et& + dpte% ' damper pedal has gone off, add positive inc to delay timing
'NOTE  all these adjustments will only take effect when the data is sorted
'back into chronological order by the routine which follows

'clear out garbage by copying non-zapped events to new file (temp.not #2)
IF en% <> 255 THEN PUT #2, , et&: PUT #2, , en%: evnt& = evnt& + 1
GOTO loop5
skip6:

CLS
PRINT "Sorting file";
p2& = 1                         ' p1& and p2& are file pointers
overlap% = 0                    ' counter to check overlaps
sort1:
sflag% = 0
IF p2& > 0 THEN p1& = p2& ELSE p1& = 1 ' begin search from p2& unless it's negative
sort2:
GET #2, p1&, et&                ' get next two events
GET #2, , en%
GET #2, , et1&
GET #2, , en1%

IF et& - et1& < 1 THEN GOTO ssort  ' if the second event is later than the first
                                   ' skip and get next
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'If an overlap is about to occur it means that the overlapping
'events will pass each other on the next swop. Therefore, zap them as they pass by.
'The zapped events will need to be removed by the MIDI builders
IF (en1% AND 127) = (en% AND 127) THEN en1% = zap%: en% = zap%: overlap% = overlap% + 1
PUT #2, p1&, et1&                  ' If the events are in the wrong order,
PUT #2, , en1%                     ' put the second event in the position
PUT #2, , et&                      ' of the first event and vice versa
PUT #2, , en%                      ' and set a flag/counter to indicate that a change
                                   ' has taken place
sflag% = sflag% + 1: IF sflag% = 1 THEN p2& = p1& - 6' set start pointer to position
                                                     ' of first swop
ssort:
p1& = p1& + 6: IF p1& < LOF(2) - 12 THEN GOTO sort2 ' increment main pointer and
                                                    ' got back to top of loop
IF sflag% <> 0 THEN PRINT sflag%; : GOTO sort1      ' End of file has been reached
'                               ' if any swops occurred, go though file again

SCREEN 9
VIEW PRINT 1 TO 24

'process to build MIDI files
title$ = CHR$(0) + CHR$(255) + CHR$(3) + CHR$(LEN(title$)) + title$
copy$ = CHR$(0) + CHR$(255) + CHR$(2) + CHR$(LEN(copy$)) + copy$
author$ = CHR$(0) + CHR$(255) + CHR$(3) + CHR$(LEN(author$)) + author$
minstruction$ = CHR$(0) + CHR$(255) + CHR$(1) + CHR$(LEN(minstruction$)) + minstruction$
minstrument$ = CHR$(0) + CHR$(255) + CHR$(4) + CHR$(LEN(minstrument$)) + minstrument$
einstruction$ = CHR$(0) + CHR$(255) + CHR$(1) + CHR$(LEN(einstruction$)) + einstruction$
einstrument$ = CHR$(0) + CHR$(255) + CHR$(4) + CHR$(LEN(einstrument$)) + einstrument$

IF OutTyp$ = "M" OR OutTyp$ = "E" THEN
  DoTyp$ = Outtyp$
  GOSUB mmidi
  SHELL "del " + sd$ + "temp.not"
  SHELL "del " + sd$ + "temp.scn"
  GOTO wayout
ELSE
  DoTyp$ = "M"
  GOSUB mmidi
  'INPUT "MIDI DONE", D$
  DoTyp$ = "E"
  GOSUB mmidi
  'INPUT "E-MIDI DONE", D$
  SHELL "del " + sd$ + "temp.not"
  SHELL "del " + sd$ + "temp.scn"
  GOTO wayout
END IF


' ############################################
' subroutines

' M MIDI subroutine (as opposed to E MIDI)

mmidi:
track1$ = ""
header$ = ""

RESTORE filedata  ' A load of standard MIDI file header data is stored in DAT
                  ' statements at the end. Reset the pointer to these.
OPEN "temp.mid" FOR BINARY AS #1    ' Open a temp file for the MIDI
'OPEN "VELDATA.TXT" FOR OUTPUT AS #10

'TOP OF HEADER BUILDING SECTION
mloop1:
READ x%     ' Get MIDI file header data, time sig, key sig, MIDI tempo etc
IF x% < 256 THEN header$ = header$ + CHR$(x%): GOTO mloop1 ' and build header strings
mloop2:
READ x%
IF x% < 256 THEN track1$ = track1$ + CHR$(x%): GOTO mloop2
'add text data
track1$ = title$ + copy$ + author$ + minstruction$ + minstrument$ + track1$
'calculate length
tl1% = LEN(track1$) MOD 256 ' The MIDI format requires strings to be stored
tl2% = LEN(track1$) \ 256   ' with their lengths - calculate these
track1$ = "MTrk" + CHR$(0) + CHR$(0) + CHR$(tl2%) + CHR$(tl1%) + track1$

PUT #1, , header$            'store header strings
PUT #1, , track1$

h$ = "MTrkXXXX"              ' Write "start of track" marker
PUT #1, , h$
plen% = SEEK(1)              ' make a note of current file pointer for later
Patch$ = Chr$(0) + Chr$(192) + Chr$(0)    ' build MIDI patch value
Put #1, , Patch$

oldtime& = 0
tottime& = 0

'the complicated compensation routine which follows only applies to DuoArt
'but will not affect Ampico or Standard
'%%%
ddwin% = 7   'dynamic droop window
SEEK 2, 1
IF UseDyn% = 1 THEN
    SEEK 4, 1
END IF

'TOP OF MAIN LOOP
mloop7:
n$ = ""
GET #2, , et&                   ' get the line number
IF EOF(2) <> 0 THEN GOTO mjump9 ' exit if end of file
GET #2, , en%                   ' get the note number
IF en% = zap% THEN GOTO mnulskip ' zapped event - skip it

IF UseDyn% = 0 THEN
    GOTO SkipDyn
END IF
GetDyn:
IF EOF(4) <> 0 THEN
    PRINT "EOF DYN ";et&, etd&
    GOTO SkipDyn ' exit if end of file
END IF
IF etd& = et& THEN
    'PRINT #10, et&,etd&,Dyn%
    GOTO SkipDyn
END IF
GET #4, , etd&
GET #4, , Dyn%
GOTO GetDyn

SkipDyn:
'%%% Make dynamic droop note count

ddc% = 0
tptr& = LOC(2) + 1'set temp pointer
etnow& = et&
'search back
z% = 12
WHILE (tptr& - z%) > 0 AND (etnow& - et&) < ddwin%
GET #2, tptr& - z%, et&
GET #2, , en%
IF en% > 127 AND en% > 138 AND en% < 219 THEN ddc% = ddc% + 1
z% = z% + 6
WEND
'PRINT ddc%,
'search ahead
z% = 0
WHILE (tptr& + z%) < LOF(2) AND (et& - etnow&) < ddwin%
GET #2, tptr& + z%, et&
GET #2, , en%
IF en% > 127 AND en% > 138 AND en% < 219 THEN ddc% = ddc% + 1
z% = z% + 6
WEND

'reset the variables
GET #2, tptr& - 6, et&
GET #2, , en%
'and contiue

'now convert note
'note on or off
IF en% AND 128 THEN n$ = CHR$(144) ELSE n$ = CHR$(128)
'tracker bar note numbers are 14 less than MIDI note numbers. Add 14
IF typ$ = "R" THEN 'Red Welte
 note% = (en% + 13) AND 127 'midi note number
ELSE
 note% = (en% + 14) AND 127 'midi note number
END IF
noteon% = en% AND 128           ' set bit 7 to mark this as a MIDI "Note on"
n$ = n$ + CHR$(note%)           ' start building MIDI event string, n$

'************************************************************
'SYSTEM SPECIFIC - calculate expression
'decide which roll type by checking letter on end of filename
IF Dotyp$ = "E" THEN
 GOSUB eroll
 GOTO AfterSelect
END IF
SELECT CASE typ$
CASE "D"
GOSUB DuoArt
CASE "A"
GOSUB AmpicoA
CASE "I"
GOSUB artrio
CASE "W"
GOSUB weltelic
CASE "R"
GOSUB weltered
CASE ELSE
GOSUB Standard
END SELECT
'************************************************************
AfterSelect:
IF LEN(n$) <> 3 THEN STOP' impossible condition
'the expression sub-routine null out non-playing events - skip them
IF LEFT$(n$, 1) = CHR$(144) AND RIGHT$(n$, 1) = CHR$(0) THEN GOTO mnulskip
IF LEFT$(n$, 1) = CHR$(128) AND RIGHT$(n$, 1) = CHR$(0) THEN GOTO mnulskip

'convert time to MIDI increment
'IF ABS(et& - oldtime&) > 500 THEN oldtime& = et& ' calculate difference between current and provious time
'standard MIDI tick rate = 400 per sec
'lpi% is encoder steps per sec
'tempo/10 * 12" / 60 secs is no. of encoder lines per second
'takeup build compensation factor (comp#) is line number/(lpi*12) to give position in roll in
'feet multiplied by compensation in percent per foot divided by 100
'efftempo% is effective roll tempo used for information only
comp# = 1 + (et& * tuc / lpi%) / 1200
efftempo% = tempo% * comp#
'build nightmare variable length MIDI delta time
dtime% = INT(((et& - oldtime&) / comp#) * 400 / (tempo% * (lpi% / 50)) + .5)
dt1& = dtime% MOD 128
dt2& = dtime% \ 128 MOD 128
dt3& = dtime% \ 16384 MOD 128
IF dt2& < 0 THEN dt2& = 0
IF dt3& < 0 THEN dt3& = 0
IF dt3& THEN dt3$ = CHR$(dt3& OR 128) ELSE dt3$ = ""
IF dt2& THEN dt2$ = CHR$(dt2& OR 128) ELSE dt2$ = ""
IF dt1& < 0 THEN dt1& = 0
dtime$ = dt3$ + dt2$ + CHR$(dt1&)
oldtime& = et&
tottime& = tottime& + dtime%

PUT #1, , dtime$          ' store MIDI delta time and
PUT #1, , n$              ' MIDI event
mnulskip:                 ' back for next event
GOTO mloop7

mjump9:                   ' main loop has finished - tidy up a few details
'end delay - play note 15
'E$ = CHR$(144) + CHR$(15) + CHR$(5)
'PUT #1, , dtime$
'PUT #1, , E$
'dtime$ = CHR$(135) + CHR$(104)'1000 ticks
'E$ = CHR$(128) + CHR$(15) + CHR$(5)
'PUT #1, , dtime$          ' play note 15
'PUT #1, , E$              ' for about 1.5 seconds

E$ = CHR$(0) + CHR$(255) + CHR$(47) + CHR$(0)    ' build MIDI terminator
PUT #1, , E$              ' and store it on the end of the file
l& = LOF(1) - plen% + 1   ' calculate length of MIDI track
l4& = 0                   ' convert number to dreaded variable length format
l3& = l& \ 65536: l& = l& - l3& * 65536
l2& = l& \ 256
l1& = l& MOD 256
l$ = CHR$(l4&) + CHR$(l3&) + CHR$(l2&) + CHR$(l1&)
PUT #1, plen% - 4, l$     ' and store track length in file

PRINT
PRINT "Minimum velocity "; vLO%
PRINT
PRINT "Maximum velocity "; vHI%
PRINT
PRINT "Initial tempo"; tempo%
PRINT
PRINT "Final effective tempo = "; efftempo%
PRINT
PRINT "Total time "; tottime& / 400

IF DoTyp$ = "M" THEN
  PRINT "Saving file to "; dfm$
  SHELL "copy temp.mid " + dfm$
ELSE
  PRINT "Saving file to "; dfe$
  SHELL "copy temp.mid " + dfe$
END IF
CLOSE #1
SHELL "del temp.mid"

RETURN
'END OF MMIDI SUBROUTINE
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

DuoArt:
'test roll values
'       Play   Don't play
'Acc 0    3       5
'Acc 1    3       5
'Acc 2    4       8
'Acc 4    7       14
'Th  0    4       6
'Th  1    4/5     7/8
'Th  2    5       10
'Th  4    6/8     14

'tracker bar dimensions
'height of note duct       0.064
'height of exp duct        0.154
'height of pedal duct      0.133
'top of exp to top of note 0.265

'variables
'ddc% note count within window set by ddwin%
'accpwr%(x) & thpwr%(x) arrays containing power values for steps 0 to 15
'acc% & th% step values 0 to 15 read from roll
'atime% & ttime% time of last change of acc% & th%
'aold% & told% value of acc% & th% before last change
'alag acc lag - time from min to max in MIDI clocks
'tlag theme lag - ditto
'avel% calculated acc veolicty
'tvel% calculated th velocity
'vel% final midi velocity

IF note% > 19 AND note% < 25 THEN     ' change of acc setting from roll
 IF note% = 21 THEN a1% = noteon% \ 128
 IF note% = 22 THEN a2% = noteon% \ 64
 IF note% = 23 THEN a3% = noteon% \ 32
 IF note% = 24 THEN a4% = noteon% \ 16
 IF note% = 20 THEN bton% = noteon% \ 128'bass theme on
 atime& = tottime& 'note time of change
 aold% = acc%      'and previous value
 acc% = (a1% + a2% + a3% + a4%) - INT(ddc% / 8)'steps 0 to 15 read from roll+ dyn droop
 IF acc% < 0 THEN acc% = 0
END IF

'add lag
IF acc% > aold% THEN  'rising power
   v1% = accpwr%(aold%) + INT(accpwr%(acc%) * (tottime& - atime&) / alag + .5)
    IF v1% > accpwr%(acc%) THEN
    avel% = accpwr%(acc%)
    ELSE avel% = v1%
    END IF
ELSE               'falling power
   v1% = accpwr%(aold%) - INT(accpwr%(accold%) * (tottime& - atime&) / alag + .5)
    IF v1% < accpwr%(acc%) THEN
    avel% = accpwr%(acc%)
    ELSE avel% = v1%
    END IF
END IF
'corrected acc power now in avel%


IF note% > 104 AND note% < 110 THEN
 IF note% = 108 THEN th1% = noteon% \ 128
 IF note% = 107 THEN th2% = noteon% \ 64
 IF note% = 106 THEN th3% = noteon% \ 32
 IF note% = 105 THEN th4% = noteon% \ 16
 IF note% = 109 THEN tton% = noteon% \ 128'treble theme on
 ttime& = tottime& 'note time of change
 told% = th%      'and previous value
 th% = (th1% + th2% + th3% + th4%) - INT(ddc% / 8)'steps 0 to 15 read from roll+ dyn droop
 IF th% < 0 THEN th% = 0
END IF

'add lag
IF th% > told% THEN  'rising power
   v1% = thpwr%(told%) + INT(thpwr%(th%) * (tottime& - ttime&) / tlag + .5)
    IF v1% > thpwr%(th%) THEN
    tvel% = thpwr%(th%)
    ELSE tvel% = v1%
    END IF
ELSE               'falling power
   v1% = thpwr%(told%) - INT(thpwr%(thold%) * (tottime& - ttime&) / tlag + .5)
    IF v1% < thpwr%(th%) THEN
    tvel% = thpwr%(th%)
    ELSE tvel% = v1%
    END IF
END IF
'corrected theme power is now in tvel%


IF note% = 113 THEN sped% = noteon% \ 128'soft pedal

'add capacitive lag

IF note% < 64 THEN 'bass notes
  IF bton% = 0 THEN
  vb1% = avel%
  ELSE
  vb1% = tvel%'
  END IF
  'bass smoothing
  
    IF (tottime& - bot&) < timeconst% THEN
    vbinc% = ABS(vbold% - vb1%)  'QB can't do ^ on a neg number

    IF vbold% >= vb1% THEN
    vbnew% = vbold% - INT(vbinc% ^ ((tottime& - bot&) / timeconst%) + .5)': PRINT v1%; vinc%; (tottime& - bot&); vold%; vnew%
    ELSE
    vbnew% = vbold% + INT(vbinc% ^ ((tottime& - bot&) / timeconst%) + .5)
    END IF
    
    ELSE
    vbnew% = vb1%
    END IF
    vbold% = vbnew%'old bass velocity
    bot& = tottime&' old bass time
    vel% = vbnew%
    'PRINT vb1%; vbnew%
ELSE               'treble notes
  IF tton% = 0 THEN
  vt1% = avel%
  ELSE
  vt1% = tvel%
  END IF
  'treble smoothing
    IF (tottime& - tot&) < timeconst% THEN
    vtinc% = ABS(vtold% - vt1%)

    IF vtold% >= vt1% THEN
    vtnew% = vtold% - INT(vtinc% ^ ((tottime& - tot&) / timeconst%) + .5)': PRINT v1%; vinc%; (tottime& - bot&); vold%; vnew%
    ELSE
    vtnew% = vtold% + INT(vtinc% ^ ((tottime& - tot&) / timeconst%) + .5)
    END IF

    ELSE
    vtnew% = vt1%
    END IF
    vtold% = vtnew%'old treb velocity
    tot& = tottime&' old treb time
    vel% = vtnew%

END IF
'velocity & clear peds & expression
IF note% < 25 THEN n$ = n$ + CHR$(0): GOTO dexpskip
IF note% > 104 THEN n$ = n$ + CHR$(0): GOTO dexpskip

PRESET (c%, (90 - vel%) * 5), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS
IF noteon% THEN notecount% = notecount% + 1
IF noteon% = 0 THEN notecount% = notecount% - 1
IF notecount% > 12 THEN notecount% = 12
IF notecount% < 0 THEN notecount% = 0

vel% = vel% - 3 * sped%'subtract 5 if soft ped is on
'%%%%%%%%%%%%%%  note count compensation
'vel% = vel% - notecount% * sdf

vel% = vel% + uplift

IF vel% > 110 THEN vel% = 110
IF vel% < accpwr%(0) THEN vel% = accpwr%(0)

'FFFFF
'treble boost  (if it's good enought for Stahnke, it's good enough for me !)
IF note% > 68 THEN vel% = vel% + 1'boost a bit above note a5
IF note% > 80 THEN vel% = vel% + 2'boost more above note a6
IF note% > 96 THEN vel% = vel% + 3'boost even more abvoe note a7
                                                                
n$ = n$ + CHR$(vel%)
dexpskip:

'damper pedal

IF LEFT$(n$, 2) = CHR$(144) + CHR$(18) THEN n$ = CHR$(176) + CHR$(64) + CHR$(127)
IF LEFT$(n$, 2) = CHR$(128) + CHR$(18) THEN n$ = CHR$(176) + CHR$(64) + CHR$(0)
'soft ped
IF LEFT$(n$, 2) = CHR$(144) + CHR$(113) THEN n$ = CHR$(176) + CHR$(67) + CHR$(127): sped% = 1
IF LEFT$(n$, 2) = CHR$(128) + CHR$(113) THEN n$ = CHR$(176) + CHR$(67) + CHR$(0): sped% = 0

RETURN

AmpicoA:
'reroll flag
IF note% = 106 THEN rrflag% = 1
'get Ampico A expression
'Ampico intensities. bpt variables follow expression track in roll
'                    bp varaibles are actual latched intensity value
'                    similarly with cancel & treb, bct ,bc:tct,tc :tpt ,tp

'BASS

IF note% = 17 THEN bpt1% = noteon%: bp1% = 6'power 1 perf
IF note% = 19 THEN bpt2% = noteon%: bp2% = 12'power 2 perf
IF note% = 21 THEN bpt3% = noteon%: bp3% = 18' power 3 perf
IF note% = 22 THEN bct% = noteon%' cancel
'cancel
IF (bct% <> 0) AND (bpt1% = 0) THEN bp1% = 0
IF (bct% <> 0) AND (bpt2% = 0) THEN bp2% = 0
IF (bct% <> 0) AND (bpt3% = 0) THEN bp3% = 0

'TREBLE
IF note% = 112 THEN tpt1% = noteon%: tp1% = 6'power 1 perf
IF note% = 110 THEN tpt2% = noteon%: tp2% = 12'power 2 perf
IF note% = 108 THEN tpt3% = noteon%: tp3% = 18' power 3 perf
IF note% = 107 THEN tct% = noteon%' cancel
'cancel
IF (tct% <> 0) AND (tpt1% = 0) THEN tp1% = 0
IF (tct% <> 0) AND (tpt2% = 0) THEN tp2% = 0
IF (tct% <> 0) AND (tpt3% = 0) THEN tp3% = 0

'Crescendos timing
'ctime% in millsecs
ctime = 1.2 * (et& - oldtime&)
range% = 35 '30 velocity steps

'Treble Crescendo
'fast  3.6 seconds slow 9 seconds
IF note% = 109 THEN tfcflag% = noteon%
IF note% = 113 THEN tscflag% = noteon%
IF tfcflag% = 128 THEN tcrescinc = ctime * range% / 3600
IF tfcflag% = 0 THEN tcrescinc = ctime * range% / 9000'power increase per time increment
IF tscflag% = 128 THEN tcvel = tcvel + tcrescinc
IF tscflag% = 0 THEN tcvel = tcvel - tcrescinc

IF tcvel > range% THEN tcvel = range%
IF tcvel < 0 THEN tcvel = 0

'Bass Crescendo
'fast  3.6 seconds slow 9 seconds
IF note% = 109 THEN bfcflag% = noteon%
IF note% = 113 THEN bscflag% = noteon%
IF bfcflag% = 128 THEN bcrescinc = ctime * range% / 3600
IF bfcflag% = 0 THEN bcrescinc = ctime * range% / 9000'power increase per time increment
IF bscflag% = 128 THEN bcvel = bcvel + bcrescinc
IF bscflag% = 0 THEN bcvel = bcvel - bcrescinc

IF bcvel > range% THEN bcvel = range%
IF bcvel < 0 THEN bcvel = 0


'Velocity
tvel% = INT(vmin% + tp1% + tp2% + tp3% + tcvel)
bvel% = INT(vmin% + bp1% + bp2% + bp3% + bcvel)

'Clear peds & expression
IF note% < 23 THEN n$ = n$ + CHR$(0): GOTO aexpskip
IF note% > 103 THEN n$ = n$ + CHR$(0): GOTO aexpskip
pwr% = tvel%
IF note% < 65 THEN pwr% = bvel%
pwr% = pwr% - 4 + INT(8 * RND(1))
PRESET (c%, (90 - bvel%) * 6), 4: PRESET (c%, (90 - tvel%) * 6), 3
c% = c% + 1: IF c% = 600 THEN c% = 1: CLS

'IF pwr% > vmax% THEN pwr% = vmax%
IF pwr% < vLO% THEN vLO% = pwr%
IF pwr% > vHI% THEN vHI% = pwr%

n$ = n$ + CHR$(pwr%)
aexpskip:

'soft ped
IF LEFT$(n$, 2) = CHR$(144) + CHR$(111) THEN n$ = CHR$(176) + CHR$(67) + CHR$(127)
IF LEFT$(n$, 2) = CHR$(128) + CHR$(111) THEN n$ = CHR$(176) + CHR$(67) + CHR$(0)

'damper pedal
IF LEFT$(n$, 2) = CHR$(144) + CHR$(18) THEN n$ = CHR$(176) + CHR$(64) + CHR$(127)
IF LEFT$(n$, 2) = CHR$(128) + CHR$(18) THEN n$ = CHR$(176) + CHR$(64) + CHR$(0)
RETURN

Standard:
'Expression for standard 88 or Themodist rolls
'velocity & clear peds & expression
 IF note% = 109 THEN tton% = noteon% \ 128'treble theme on
 IF note% = 20 THEN bton% = noteon% \ 128'bass theme on

IF UseDyn% = 1 THEN
    IF Dyn% <> 0 THEN
        vel% = Dyn%
    END IF
ELSE
    vel% = 70
END IF
IF tton% = 1 AND note% > 63 THEN vel% = vel% + 15'treble theme
IF bton% = 1 AND note% < 64 THEN vel% = vel% + 15'bass theme
IF vel% > 127 THEN vel% = 127

IF note% < 21 THEN n$ = n$ + CHR$(0): GOTO sexpskip
IF note% > 108 THEN n$ = n$ + CHR$(0): GOTO sexpskip

PRESET (c%, (90 - vel%) * 5), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS

n$ = n$ + CHR$(vel%)
sexpskip:

'damper pedal

IF LEFT$(n$, 2) = CHR$(144) + CHR$(18) THEN n$ = CHR$(176) + CHR$(64) + CHR$(127)
IF LEFT$(n$, 2) = CHR$(128) + CHR$(18) THEN n$ = CHR$(176) + CHR$(64) + CHR$(0)
'soft ped
IF LEFT$(n$, 2) = CHR$(144) + CHR$(113) THEN n$ = CHR$(176) + CHR$(67) + CHR$(127): sped% = 1
IF LEFT$(n$, 2) = CHR$(128) + CHR$(113) THEN n$ = CHR$(176) + CHR$(67) + CHR$(0): sped% = 0

RETURN

'Artrio expression ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
artrio:
'get artrio expression
IF note% = 114 THEN p1% = noteon% * 10
IF note% = 112 THEN p2% = noteon% * 10
IF note% = 107 THEN p3% = noteon% * 15 'flat out
IF note% = 111 THEN p4% = noteon% * 10
IF note% = 108 THEN p5% = noteon% * 10
vel% = 32 + (p1% + p2% + p3% + p4% + p5%)


'theme
IF (note% = 19 OR note% = 20) THEN btheme% = noteon% \ 128
IF (note% = 109 OR note% = 110) THEN ttheme% = noteon% \ 128

IF note% < 62 THEN vel% = vel% + btheme% * 10
IF note% > 61 THEN vel% = vel% + ttheme% * 10
'velocity & clear peds & expression
IF note% < 25 THEN n$ = n$ + CHR$(0): GOTO arexpskip
IF note% > 104 THEN n$ = n$ + CHR$(0): GOTO arexpskip
      
PRESET (c%, (vel% - 40) * 12), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS
n$ = n$ + CHR$(vel%)
arexpskip:

'damper pedal
IF LEFT$(n$, 2) = CHR$(144) + CHR$(17) THEN n$ = CHR$(176) + CHR$(64) + CHR$(127)
IF LEFT$(n$, 2) = CHR$(128) + CHR$(17) THEN n$ = CHR$(176) + CHR$(64) + CHR$(0)
'soft ped
IF LEFT$(n$, 2) = CHR$(144) + CHR$(113) THEN n$ = CHR$(176) + CHR$(67) + CHR$(127)
IF LEFT$(n$, 2) = CHR$(128) + CHR$(113) THEN n$ = CHR$(176) + CHR$(67) + CHR$(0)

RETURN

'E Rolls
eroll:
vel% = 65
IF note% < 25 THEN vel% = 5
IF note% > 104 THEN vel% = 5

PRESET (c%, (vel% - 40) * 12), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS
n$ = n$ + CHR$(vel%)
RETURN

weltelic:
'get weltelic expression

IF note% = 20 THEN bfzp% = noteon%
IF note% = 21 THEN bfzf% = noteon%
IF note% = 108 THEN tfzf% = noteon%
IF note% = 109 THEN tfzp% = noteon%

IF noteon% = 0 THEN GOTO wel1' note offs don't matter
IF note% = 16 THEN bmf% = 0
IF note% = 17 THEN bmf% = 1
IF note% = 18 THEN bcr% = 0
IF note% = 19 THEN bcr% = 1
IF note% = 110 THEN tcr% = 1
IF note% = 111 THEN tcr% = 0
IF note% = 112 THEN tmf% = 1
IF note% = 113 THEN tmf% = 0
wel1:

'Crescendos timing
'ctime% in millsecs

ctime = 1.2 * (et& - oldtime&)
range% = 35 '35 velocity steps
vmin% = 45
mf% = vmin% + range% * .4

'Treble
'cresc  up & down 5 seconds
'fz up .36 seconds
'fz down .16 seconds

IF tcr% = 1 THEN tvel% = tvel% + ctime * range% / 5000
IF tcr% = 0 THEN tvel% = tvel% - ctime * range% / 3000
IF tfzf% <> 0 THEN tvel% = tvel% + (ctime * range% / 500)
IF tfzp% <> 0 THEN tvel% = tvel% - (ctime * range% / 300)
IF tmf% = 1 THEN tvel% = mf%
IF tvel% > vmin% + range% THEN tvel% = vmin% + range%
IF tvel% < vmin% THEN tvel% = vmin%

'Bass Crescendo
IF bcr% = 1 THEN bvel% = bvel% + ctime * range% / 5000
IF bcr% = 0 THEN bvel% = bvel% - ctime * range% / 3000
IF bfzf% <> 0 THEN bvel% = bvel% + (ctime * range% / 500)
IF bfzp% <> 0 THEN bvel% = bvel% - (ctime * range% / 300)

IF bmf% = 1 THEN bvel% = mf%
IF bvel% > vmin% + range% THEN bvel% = vmin% + range%
IF bvel% < vmin% THEN bvel% = vmin%


'Velocity
'Clear peds & expression
IF note% < 24 THEN n$ = n$ + CHR$(0): GOTO wexpskip
IF note% > 103 THEN n$ = n$ + CHR$(0): GOTO wexpskip
pwr% = tvel%
IF note% < 65 THEN pwr% = bvel%
PRESET (c%, (vmax% - bvel%) * 6), 4: PRESET (c%, (vmax% - tvel%) * 6), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS

IF pwr% < vLO% THEN vLO% = pwr%
IF pwr% > vHI% THEN vHI% = pwr%
pwr% = pwr% - 4 + INT(8 * RND(1))
n$ = n$ + CHR$(pwr%)
wexpskip:

'soft ped
IF (note% = 23) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(67) + CHR$(127)
IF (note% = 22) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(67) + CHR$(0)

'damper pedal
IF (note% = 106) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(64) + CHR$(127)
IF (note% = 107) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(64) + CHR$(0)
RETURN


weltered:
'get welte red expression

IF note% = 18 THEN bfzp% = noteon%
IF note% = 19 THEN bfzf% = noteon%
IF note% = 108 THEN tfzf% = noteon%
IF note% = 109 THEN tfzp% = noteon%

IF noteon% = 0 THEN GOTO welr1' note offs don't matter
IF note% = 14 THEN bmf% = 0
IF note% = 15 THEN bmf% = 1
IF note% = 16 THEN bcr% = 0
IF note% = 17 THEN bcr% = 1
IF note% = 22 THEN pump% = 1
IF note% = 23 THEN pump% = 0
IF note% = 110 THEN tcr% = 1
IF note% = 111 THEN tcr% = 0
IF note% = 112 THEN tmf% = 1
IF note% = 113 THEN tmf% = 0
welr1:

'Crescendos timing
'ctime% in millsecs
ctime = 1.2 * (et& - oldtime&)
range% = 35 '35 velocity steps
vmin% = 55
mf% = vmin% + range% * .4

'Treble
'cresc  up & down 5 seconds
'fz up .36 seconds
'fz down .16 seconds

IF tcr% = 1 THEN tvel% = tvel% + ctime * range% / 5000
IF tcr% = 0 THEN tvel% = tvel% - ctime * range% / 3000
IF tfzf% <> 0 THEN tvel% = tvel% + (ctime * range% / 500)
IF tfzp% <> 0 THEN tvel% = tvel% - (ctime * range% / 300)
'IF tmf% = 1 THEN tvel% = mf%
IF tvel% > vmin% + range% THEN tvel% = vmin% + range%
IF tvel% < vmin% THEN tvel% = vmin%

'Bass Crescendo
IF bcr% = 1 THEN bvel% = bvel% + ctime * range% / 5000
IF bcr% = 0 THEN bvel% = bvel% - ctime * range% / 3000
IF bfzf% <> 0 THEN bvel% = bvel% + (ctime * range% / 500)
IF bfzp% <> 0 THEN bvel% = bvel% - (ctime * range% / 300)

'IF bmf% = 1 THEN bvel% = mf%
IF bvel% > vmin% + range% THEN bvel% = vmin% + range%
IF bvel% < vmin% THEN bvel% = vmin%


'Velocity
'Clear peds & expression
IF note% < 24 THEN n$ = n$ + CHR$(0): GOTO werxpskip
IF note% > 103 THEN n$ = n$ + CHR$(0): GOTO werxpskip
pwr% = tvel%
IF note% < 65 THEN pwr% = bvel%
PRESET (c%, (vmax% - bvel%) * 6), 4: PRESET (c%, (vmax% - tvel%) * 6), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS
PRESET (c%, 30 - pump% * 10), 5
'pump switch
pwr% = pwr% + pump% * 12
IF pwr% < vLO% THEN vLO% = pwr%
IF pwr% > vHI% THEN vHI% = pwr%
pwr% = pwr% - 4 + INT(8 * RND(1))
n$ = n$ + CHR$(pwr%)
werxpskip:

'soft ped
IF (note% = 20) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(67) + CHR$(127)
IF (note% = 21) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(67) + CHR$(0)
            
'damper pedal
IF (note% = 106) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(64) + CHR$(127)
IF (note% = 107) AND (noteon% = 128) THEN n$ = CHR$(176) + CHR$(64) + CHR$(0)
RETURN

'end of expression subroutines stored here 9 Feb 2000


wayout:
CLOSE #1
CLOSE #2
CLOSE #3
CLOSE #4
END SUB

