
'Temporary Universal version for the group 26 Dec 2002 - and still sober !
'65 note mod 03/12/03 KMK

COMMON SHARED Debug%
DECLARE SUB midiproc (filename AS STRING, sd AS STRING, dd AS STRING, typ AS STRING, fcount AS SINGLE)


    DataIn$ = COMMAND$

    IF DataIn$ = "" THEN
	GOTO NormalRun
    END IF

    Debug% = INSTR(DataIn$, "/D")
    IF Debug% THEN
	DataIn$ = RTRIM$(LEFT$(DataIn$, Debug% - 1))
    END IF

    a% = INSTR(DataIn$, "/")

    IF a% = 0 THEN
	FileName$ = RTRIM$(DataIn$)
	sys% = 10
    ELSE
	FileName$ = RTRIM$(LEFT$(DataIn$, a% - 1))
	sys% = VAL(RIGHT$(DataIn$, LEN(DataIn$) - a%))
    END IF

    IF INSTR(FileName$, ".") <> 0 THEN
	FileName$ = LEFT$(FileName$, LEN(FileName$) - 4)
    END IF

NormalRun:
'Specify source and destination directories~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sd$ = "c:\scans\"      'source directory
dd$ = "c:\scans\"      'destination directory
SHELL "del " + sd$ + "temp.*"


CLS : PRINT : PRINT : PRINT

PRINT
PRINT "                65 NOTE SCN to MID BULK CONVERTOR"
PRINT "                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
PRINT "                    UNIVERSAL VERSION"
PRINT "                    ~~~~~~~~~~~~~~~~~"
PRINT : PRINT
PRINT : PRINT "Specified directories must exist"
PRINT : PRINT "Press Return to use defaults"
PRINT
PRINT "Source Directory (default is "; sd$; ")"
INPUT D$
IF D$ <> "" THEN sd$ = D$
IF D$ = "." THEN sd$ = ""
PRINT : PRINT "Destination Directory (default is "; dd$; ")"
INPUT D$
IF D$ <> "" THEN dd$ = D$
IF D$ = "." THEN dd$ = ""
typ$ = "S"

SHELL "echo off"
SHELL "del filelist.txt"
SHELL "del errorlog.txt"            'create empty error file
OPEN "errorlog.txt" FOR OUTPUT AS #7
CLOSE #7
SHELL "echo on"
SHELL "dir " + sd$ + "*.scn /b /ON > filelist.txt"
' .scn filenames are now in 'filelist.txt'

IF FileName$ <> "" THEN
    CALL midiproc(filename$, sd$, dd$, typ$, fcount)
    GOTO Quit
END IF

oldlist:
OPEN "filelist.txt" FOR INPUT AS #5
'count number of .scn files into fcount
fcount = 0
WHILE NOT EOF(5)
LINE INPUT #5, f$
IF UCASE$(RIGHT$(f$, 3)) = "SCN" THEN PRINT f$, : fcount = fcount + 1: IF LEN(f$) > 12 THEN STOP
WEND

SEEK #5, 1
'get first filename
WHILE fcount > 0
LINE INPUT #5, f$
IF UCASE$(RIGHT$(f$, 3)) <> "SCN" THEN GOTO skipa
af$ = LEFT$(f$, LEN(f$) - 4)
filename$ = af$

CALL midiproc(filename$, sd$, dd$, typ$, fcount)
skipa:
fcount = fcount - 1

WEND
Quit:
CLOSE

END


filedata:  'MIDI setup data & meta events
DATA 77,84,104,100,0,0,0,6,0,1,0,2,0,200,256
DATA 0,255,88,4,4,2,24,8,0,255,81,3,7,161,32,0,255,47,0,256
DATA 77,84,104,100,0,0,0,6,0,1,0,2,0,200,256
DATA 0,255,88,4,4,2,24,8,0,255,81,3,7,161,32,0,255,47,0,256

SUB midiproc (filename AS STRING, sd AS STRING, dd AS STRING, typ AS STRING, fcount AS SINGLE)
'
CLS
PRINT : PRINT : PRINT : PRINT
PRINT "                    SCN to MIDI PROCESSOR"

DIM zap%(101)   'Array used for web remover "stalagmite" display
DIM spk%(101)   ' ditto for speck remover
DIM cat$(5)     'Catalogue array
DIM A$(10)      'ANN array
'some variables

zap% = 255      'note value used to kill unwanted events
vmin% = 45      'minimum velocity allowed in expression algorithm
vmax% = 90      'maximum velocity allowed in expression algorithm
vHI% = 0        'starting value used in finding max velocity of current file
vLO% = 128      'starting value used in finding min velocity of current file
p1& = 1         'file pointer used by web remover
p2& = 1         'file pointer used by web remover
dlm& = 0        'SCN file de-limiter
evnt& = 0      'number of events in SCN file
tempo% = 0      'marked roll tempo
tempadjust! = 1 'real number value used to adjust distance variables
et& = 0         'line number in SCN file
en% = 0         'note num in SCN file, bit 7 set if note on, clear if note off
lpi% = 0        'scanner line per inch
f$ = ""                    'filename without path or extension
sf$ = ""                   'source filename with path
dfm$ = ""                  'MIDI destination filename
dfe$ = ""                  'E-roll destination filename
dfa$ = ""                  'ANN file name

SHELL "del " + sd$ + "temp.*"'  delete any leftover temp file

f$ = LEFT$(filename$, 7)          'truncate filename to seven chars max

sf$ = sd$ + f$ + ".scn"

dfm$ = dd$ + f$ + ".mid"   'MIDI destination filename
dfe$ = dd$ + f$ + "e.mid"  'E-roll destination filename
dfa$ = dd$ + f$ + "e.ann"  'ANN filename
PRINT : PRINT
SHELL "copy " + sf$ + " " + sd$ + "temp.scn"' copy SCN file to temp storage

' Opens the files for read/write acccess

OPEN sd$ + "temp.not" FOR BINARY AS #2
OPEN sd$ + "temp.scn" FOR BINARY AS #3

'########## skip empty files

IF LOF(3) < 20 THEN
 OPEN "errorlog.txt" FOR APPEND AS #7
 D$ = "No data in " + sf$
 PRINT #7, D$
 CLOSE #7
 GOTO wayout
END IF


'Various parameters are hung on the end of the file.  They will be moved into
'a proper header in the next major revision.
'The final event is 21 bytes in from the end of the file
'It is read here and printed purely as a debug aid
'After the final event comes the number 1000000 as a delimiter

GET #3, LOF(3) - 21, et& ' final line number in file
GET #3, , en%            ' final note in file
GET #3, , dlm&           ' delimiter
GET #3, , sysnum%        ' System number but ignored here
GET #3, , tempo%         ' Roll tempo
GET #3, , lpi%           ' Scanner lpi
GET #3, , x%             ' Spare
GET #3, , evnt&          ' Total number of events in this file

sysnum% = 10'65 only
' ****************** skip dud files
IF dlm& <> 1000000 THEN
 OPEN "errorlog.txt" FOR APPEND AS #7
 D$ = "Invalid file format in " + sf$
 PRINT #7, D$
 CLOSE #7
 GOTO wayout
END IF

IF tempo% = 0 THEN
 OPEN "errorlog.txt" FOR APPEND AS #7
 D$ = "Tempo" + STR$(tempo%) + " in " + sf$
 PRINT #7, D$
 CLOSE #7
 GOTO wayout
END IF


nmax% = 9'3 * lpi% / 180  'was 15 then 10 Note max web width                    'SO FAR THESE VALUES
pmax% = 25 * lpi% / 180  'was 25 Pedal/expression track max web width  'SEEM TO MAKE VERY
tmax% = 4 * lpi% / 180   'was 9 Theme track max web width             'GOOD MUSIC, VERY
notele% = 0     'note leading edge correction for valve lag
notete% = 0     'note trailing edge correction for valve lag
dple% = 0 * lpi% / 180  'was -6 Damper pedal leading edge         'THESE WERE TOO HIGH
dpte% = 0 * lpi% / 180   'was 6 Damper pedal trailing edge
tuc = 0'-.1        'Takeup spool build compensation
speck% = 5'9 * lpi% / 180 'Maximum speck size
copy$ = "Scanned by Terry Smythe, Winnipeg, Canada"
author$ = ""
einstruction$ = ""
minstruction$ = "Roll expression/accent tracks converted to MIDI velocties."
 

' Print file details on screen
PRINT
PRINT "No of scanner lines "; et&; "  Final event "; en%
PRINT "Tempo "; tempo%
PRINT "Scanner step rate "; lpi%;
PRINT "  Number of scan events "; evnt&
PRINT : PRINT "The following parameters are set to the values shown :-":
PRINT "Damper pedal"; TAB(33); "Leading edge"; dple%; TAB(50); "Trailing edge "; dpte%
PRINT "Note web width                 "; nmax%
PRINT "Pedal/expression web width     "; pmax%
PRINT "Take up build comp in % per ft "; tuc
PRINT "Maximum speck size             "; speck%
PRINT "Copyright string               "; copy$
PRINT
PRINT "Source filename                "; sf$

title$ = cat$(2) + " " + cat$(3) + " " + cat$(4)
IF cat$(1) = "" THEN title$ = "Player Piano Roll # " + f$
PRINT "Title "; title$
einstrument$ = "Trackerbar Image:LPI" + STR$(lpi%) + ":Tempo " + STR$(tempo%) + ": " + DATE$
minstrument$ = "Standard MIDI:LPI" + STR$(lpi%) + ":Tempo " + STR$(tempo%) + ": " + DATE$
INPUT "Press any key to continue "; i$
CLS

PRINT
IF tempo% = 0 THEN INPUT "Marked roll tempo "; tempo%


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'SCN FILE PROCESSING STARTS HERE

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
tempjump:
SCREEN 9
VIEW PRINT 20 TO 24
SEEK (2), 1'    reset file pointers
SEEK (3), 1
FOR x% = 0 TO 100'      draw ruler at bottom of screen
IF x% MOD 10 THEN PRESET (x% * 6, 302), 5 ELSE PSET (x% * 6, 302), 9
NEXT
PRESET (24, 304), 7: PRESET (594, 304), 7' draw damper & soft pedal markers

'remove webbing
PRINT "Removing webbing (red) and specks (cyan)"
PRINT "Processing "; filename$; "  "; fcount - 1; "more files to process."
p1& = 1 '       set file pointer to start of file

mainloop1:
p2& = p1&                          ' set search ahead pointer to main pointer
GET #3, p1&, et&                   ' get a line number
IF p1& = 1000000 THEN GOTO onw1    ' end of file ? if yes, exit
GET #3, , en%                      ' get a note
IF en% = 255 THEN GOTO nextevent   ' already zapped - skip to next
IF en% > 127 THEN GOTO nextevent   ' web will always start with "note off" event

'  if we get here it means we have found a "note off" event and we need to
'  set the web width parameters appropriately
webwidth% = nmax%                                   ' note web width

' now search ahead through file using pointer p2& to find a matching "note on"
look3:
p2& = p2& + 6: IF p2& > evnt& * 6 THEN GOTO nextw ' search ptr at end of file ? - exit

GET #3, p2&, et1&                   ' get next event in file
GET #3, , en1%                      ' get associated note

'Wanted and unwanted events might have the same line number so the next test
'checks to see if the search window has been exceeded.
IF et1& - et& > webwidth% THEN GOTO nextw' is the difference in line numbers
'                                           greater than the web window ?

IF (en1% - 128) <> en% THEN GOTO look3  ' loop until you find a matching "note on"

PUT #3, p1& + 4, zap%  ' if it gets here it means these events were the same
PUT #3, p2& + 4, zap%  ' note and within the webwidth window i.e. a web
'                        therefore, zap both

zap%(en%) = zap%(en%) + 1          ' add 1 to the display array
PRESET (en% * 6, 303 - zap%(en%)), 4' and draw "stalagmites"

'NEW NEW NEW 02/06/99
GOTO nextevent
nextw:

' SPECK REMOVER
' we are still in the web/speck processing loop looking at a "note off"
' we now need to see if this event pair has an excessively short duration

p2& = p1&        ' reset search pointer to main pointer
'IF (en% = 134) OR (en% = 223) THEN GOTO nextevent ' theme "note ons"  - skip
'IF (en% = 6) OR (en% = 95) THEN GOTO nextevent    ' theme "note offs" - skip
look1:
p2& = p2& - 6: IF p2& < 1 THEN GOTO nextevent' search ptr at start of file ? - exit

GET #3, p2&, et1&                      ' get event at search pointer
GET #3, , en1%
IF et& - et1& > speck% THEN GOTO nextevent 'duration > window ? if yes, move on
IF en1% <> en% + 128 THEN GOTO look1 ' matching "note on" ? - if not, get next
'PRINT et& - et1&;
PUT #3, p1& + 4, zap%                ' zap event at main pointer (note on)
PUT #3, p2& + 4, zap%                ' zap event at search pointer (note off)
spk%(en%) = spk%(en%) + 1          ' add 1 to display array
PRESET (en% * 6 + 1, 303 - spk%(en%)), 3' draw pretty picture

nextevent:
'IF p1& MOD 600 = 1 THEN PRINT p1& \ 6
p1& = p1& + 6
IF p1& < LOF(3) - 12 THEN GOTO mainloop1

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@

 'shift events
'PRINT "begin shifting events"

onw1:
SEEK (2), 1
SEEK (3), 1
evnt& = 0
loop5:
GET #3, , et&
GET #3, , en%
IF et& = 1000000 THEN GOTO skip6
IF en% = 132 THEN et& = et& + dple%' damper pedal has gone on, add negative inc to advance timing
IF en% = 4 THEN et& = et& + dpte% ' damper pedal has gone off, add positive inc to delay timing
'NOTE  all these adjustments will only take effect when the data is sorted
'back into chronological order by the routine which follows

'clear out garbage by copying non-zapped events to new file (temp.not #2)
IF en% <> 255 THEN PUT #2, , et&: PUT #2, , en%: evnt& = evnt& + 1
GOTO loop5
skip6:

CLS
PRINT "Sorting file";
p2& = 1                         ' p1& and p2& are file pointers
overlap% = 0                    ' counter to check overlaps
sort1:
sflag% = 0
IF p2& > 0 THEN p1& = p2& ELSE p1& = 1 ' begin search from p2& unless it's negative
sort2:
GET #2, p1&, et&                ' get next two events
GET #2, , en%
GET #2, , et1&
GET #2, , en1%

IF et& - et1& < 1 THEN GOTO ssort  ' if the second event is later than the first
                                   ' skip and get next
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
'If an overlap is about to occur it means that the overlapping
'events will pass each other on the next swop. Therefore, zap them as they pass by.
'The zapped events will need to be removed by the MIDI builders
IF (en1% AND 127) = (en% AND 127) THEN en1% = zap%: en% = zap%: overlap% = overlap% + 1
PUT #2, p1&, et1&                  ' If the events are in the wrong order,
PUT #2, , en1%                     ' put the second event in the position
PUT #2, , et&                      ' of the first event and vice versa
PUT #2, , en%                      ' and set a flag/counter to indicate that a change
                                   ' has taken place
sflag% = sflag% + 1: IF sflag% = 1 THEN p2& = p1& - 6' set start pointer to position
                                                     ' of first swop
ssort:
p1& = p1& + 6: IF p1& < LOF(2) - 12 THEN GOTO sort2 ' increment main pointer and
                                                    ' got back to top of loop
IF sflag% <> 0 THEN PRINT sflag%; : GOTO sort1      ' End of file has been reached
'                               ' if any swops occurred, go though file again

SCREEN 9
VIEW PRINT 1 TO 24

'process to build MIDI files
title$ = CHR$(0) + CHR$(255) + CHR$(3) + CHR$(LEN(title$)) + title$
copy$ = CHR$(0) + CHR$(255) + CHR$(2) + CHR$(LEN(copy$)) + copy$
author$ = CHR$(0) + CHR$(255) + CHR$(3) + CHR$(LEN(author$)) + author$
minstruction$ = CHR$(0) + CHR$(255) + CHR$(1) + CHR$(LEN(minstruction$)) + minstruction$
minstrument$ = CHR$(0) + CHR$(255) + CHR$(4) + CHR$(LEN(minstrument$)) + minstrument$
einstruction$ = CHR$(0) + CHR$(255) + CHR$(1) + CHR$(LEN(einstruction$)) + einstruction$
einstrument$ = CHR$(0) + CHR$(255) + CHR$(4) + CHR$(LEN(einstrument$)) + einstrument$


GOSUB mmidi

GOTO wayout



' ############################################
' subroutines

' M MIDI subroutine (as opposed to E MIDI)

mmidi:
track1$ = ""
header$ = ""

RESTORE filedata  ' A load of standard MIDI file header data is stored in DAT
                  ' statements at the end. Reset the pointer to these.
OPEN "temp.mid" FOR BINARY AS #1    ' Open a temp file for the MIDI

'TOP OF HEADER BUILDING SECTION
mloop1:
READ x%     ' Get MIDI file header data, time sig, key sig, MIDI tempo etc
IF x% < 256 THEN header$ = header$ + CHR$(x%): GOTO mloop1 ' and build header strings
mloop2:
READ x%
IF x% < 256 THEN track1$ = track1$ + CHR$(x%): GOTO mloop2
'add text data
track1$ = title$ + copy$ + author$ + minstruction$ + minstrument$ + track1$
'calculate length
tl1% = LEN(track1$) MOD 256 ' The MIDI format requires strings to be stored
tl2% = LEN(track1$) \ 256   ' with their lengths - calculate these
track1$ = "MTrk" + CHR$(0) + CHR$(0) + CHR$(tl2%) + CHR$(tl1%) + track1$

PUT #1, , header$            'store header strings
PUT #1, , track1$

h$ = "MTrkXXXX"              ' Write "start of track" marker
PUT #1, , h$
plen% = SEEK(1)              ' make a note of current file pointer for later

oldtime& = 0
tottime& = 0

SEEK 2, 1

'TOP OF MAIN LOOP
mloop7:
n$ = ""
GET #2, , et&                   ' get the line number
IF EOF(2) <> 0 THEN GOTO mjump9 ' exit if end of file
GET #2, , en%                   ' get the note number
IF en% = zap% THEN GOTO mnulskip ' zapped event - skip it

'now convert note
'note on or off
IF en% AND 128 THEN n$ = CHR$(144) ELSE n$ = CHR$(128)
'tracker bar note numbers are 35 less than MIDI note numbers. Add 35
note% = (en% + 32) AND 127 'midi note number
noteon% = en% AND 128           ' set bit 7 to mark this as a MIDI "Note on"
n$ = n$ + CHR$(note%)           ' start building MIDI event string, n$
GOSUB Standard
'************************************************************

IF LEN(n$) <> 3 THEN STOP' impossible condition
'the expression sub-routine null out non-playing events - skip them

'convert time to MIDI increment
'IF ABS(et& - oldtime&) > 500 THEN oldtime& = et& ' calculate difference between current and provious time
'standard MIDI tick rate = 400 per sec
'lpi% is encoder steps per sec
'tempo/10 * 12" / 60 secs is no. of encoder lines per second
'takeup build compensation factor (comp#) is line number/(lpi*12) to give position in roll in
'feet multiplied by compensation in percent per foot divided by 100
'efftempo% is effective roll tempo used for information only
comp# = 1 + (et& * tuc / lpi%) / 1200
efftempo% = tempo% * comp#
'build nightmare variable length MIDI delta time
dtime% = INT(((et& - oldtime&) / comp#) * 400 / (tempo% * (lpi% / 50)) + .5)
dt1& = dtime% MOD 128
dt2& = dtime% \ 128 MOD 128
dt3& = dtime% \ 16384 MOD 128
IF dt2& < 0 THEN dt2& = 0
IF dt3& < 0 THEN dt3& = 0
IF dt3& THEN dt3$ = CHR$(dt3& OR 128) ELSE dt3$ = ""
IF dt2& THEN dt2$ = CHR$(dt2& OR 128) ELSE dt2$ = ""
IF dt1& < 0 THEN dt1& = 0
dtime$ = dt3$ + dt2$ + CHR$(dt1&)
oldtime& = et&
tottime& = tottime& + dtime%

PUT #1, , dtime$          ' store MIDI delta time and
PUT #1, , n$              ' MIDI event
mnulskip:                 ' back for next event
GOTO mloop7

mjump9:                   ' main loop has finished - tidy up a few details
'end delay - play note 15
'E$ = CHR$(144) + CHR$(15) + CHR$(5)
'PUT #1, , dtime$
'PUT #1, , E$
'dtime$ = CHR$(135) + CHR$(104)'1000 ticks
'E$ = CHR$(128) + CHR$(15) + CHR$(5)
'PUT #1, , dtime$          ' play note 15
'PUT #1, , E$              ' for about 1.5 seconds

E$ = CHR$(0) + CHR$(255) + CHR$(47) + CHR$(0)    ' build MIDI terminator
PUT #1, , E$              ' and store it on the end of the file
l& = LOF(1) - plen% + 1   ' calculate length of MIDI track
l4& = 0                   ' convert number to dreaded variable length format
l3& = l& \ 65536: l& = l& - l3& * 65536
l2& = l& \ 256
l1& = l& MOD 256
l$ = CHR$(l4&) + CHR$(l3&) + CHR$(l2&) + CHR$(l1&)
PUT #1, plen% - 4, l$     ' and store track length in file

PRINT
PRINT "Minimum velocity "; vLO%
PRINT
PRINT "Maximum velocity "; vHI%
PRINT
PRINT "Initial tempo"; tempo%
PRINT
PRINT "Final effective tempo = "; efftempo%
PRINT
PRINT "Total time "; tottime& / 400

PRINT "Saving file to "; dfm$
SHELL "copy temp.mid " + dfm$
CLOSE #1
SHELL "del temp.mid"
SHELL "del " + sd$ + "temp.not"
SHELL "del " + sd$ + "temp.scn"

RETURN
'END OF MMIDI SUBROUTINE
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Standard:
vel% = 80

PRESET (c%, (90 - vel%) * 5), 3: c% = c% + 1: IF c% = 600 THEN c% = 1: CLS

n$ = n$ + CHR$(vel%)

RETURN

wayout:
CLOSE #1
CLOSE #2
CLOSE #3

END SUB

