'Universal Version 23 Dec 2002 RWS
'Tidied and batch/non-batch option added 23 Feb 2003 RWS
'Experimental version with encoder processing 9 March 2003

DECLARE SUB scnproc (filename AS STRING, sd AS STRING, dd AS STRING, note0 AS INTEGER, space AS DOUBLE, endflag AS INTEGER)


'Enter values approriate to your scanner in the next two lines
'note99% will usually be 3300 greater than note0%

note0% = 176
'note99% = 3445
space# = 50


'SET UP SOURCE AND DESTINATION DIRECTORIES ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
sd$ = "c:\scans"  'source directory
dd$ = "c:\scans"  'destination directory
bmodsbyte% = 0'batch mode
endflag% = 0
CLS : PRINT : PRINT : PRINT
PRINT
PRINT
PRINT "            UNIVERSAL CIS FILE TO SCN CONVERTOR"
PRINT "            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
PRINT "       TEMPORARY VERSION FOR USE WITH POSITION ENCODER"
PRINT "       +++++++++++++++++++++++++++++++++++++++++++++++"
PRINT "                      30th March 2003"
PRINT "                   bonzo@globalnet.co.uk"
PRINT : PRINT
PRINT : PRINT : PRINT : PRINT : PRINT
PRINT "Specified directories must exist"
PRINT : PRINT "Press Return to use defaults"
PRINT : PRINT
PRINT "Source Directory (default is "; sd$; ")"
INPUT d$
IF d$ <> "" THEN sd$ = d$
PRINT : PRINT "Destination Directory (default is "; dd$; ")"
INPUT d$
IF d$ <> "" THEN dd$ = d$
PRINT : PRINT : PRINT : PRINT "<space> switches note display off"
PRINT "<return> switches note display on"
PRINT "z key displays DP edge"
PRINT "x key displays centre"
PRINT "c key displays SP edge"
PRINT "a key displays dual array alignment mode"
PRINT "<escape> stops processing"


PRINT : ' INPUT "Press <return> to continue", i$


'The file 'filelist.txt' contains a list of allthe CIS files
'in the current directory

SHELL "echo off"
SHELL "del filelist.txt"
SHELL "echo on"
SHELL "dir " + sd$ + "*.cis /b > filelist.txt"
' .cis filenames are now in 'filelist.txt'

oldlist:
OPEN "filelist.txt" FOR INPUT AS #5
'count number of .cis files into fcount%
fcount% = 0
PRINT : PRINT "The following files have been found in this folder :-"
PRINT
WHILE NOT EOF(5)
LINE INPUT #5, F$
IF RIGHT$(UCASE$(F$), 3) = "CIS" THEN PRINT F$, : fcount% = fcount% + 1: IF LEN(F$) > 12 THEN STOP
WEND
SEEK #5, 1
'get first filename
DO WHILE fcount% > 0
LINE INPUT #5, F$
IF UCASE$(RIGHT$(F$, 3)) <> "CIS" THEN GOTO skipa
af$ = LEFT$(F$, LEN(F$) - 4)
filename$ = LEFT$(af$, 8)'lop off long filenames
PRINT : PRINT : PRINT "About to process "; filename$: PRINT

IF bmodsbyte% = 0 THEN
PRINT "Note 0 is currenty set to"; note0%
INPUT "Press return to use this value or enter a new one "; i%
IF i% <> 0 THEN note0% = i%
'PRINT "Note 99 is currently set to"; note99%
'INPUT "Press return to use this value or enter a new one "; i%
'IF i% <> 0 THEN note99% = i%

INPUT "Prompt between files "; i$
IF UCASE$(i$) <> "Y" THEN bmodsbyte% = 1 ELSE bmodsbyte% = 0
END IF

CALL scnproc(filename$, sd$, dd$, note0%, space#, endflag%)
IF endflag% <> 0 THEN EXIT DO
skipa:
fcount% = fcount% - 1
LOOP

CLOSE
END

SUB scnproc (filename AS STRING, sd AS STRING, dd AS STRING, note0 AS INTEGER, space AS DOUBLE, endflag AS INTEGER)
'29/11/2002 memory space increased to allow for 300 dpi arrays
top:

DIM notsbyte%(104) 'note array - represents piano keyboard state
DIM prev%(104) 'version of note array last time round
DIM map%(3700) ' pixel array from scanner
DIM ips(50) 'for averaging ips
DIM elc&(1000) 'for averaging encouder counts
n0t% = note0%
'n99t% = note99%

avstart% = 50' number of encoder ticks to average
eecount% = 0'encoder error count
d$ = " "
SCREEN 0
CLS
SHELL "del " + sd$ + filename$ + ".scn"
OPEN sd$ + filename$ + ".cis" FOR BINARY AS #1
OPEN sd$ + filename$ + ".scn" FOR BINARY AS #2
'OPEN sd$ + filename$ + ".dbg" FOR OUTPUT AS #3
SHELL "del temp.cis"
d$ = STRING$(32, 32)
'set DuoArt flag
IF UCASE$(RIGHT$(filename$, 1)) = "D" OR UCASE$(RIGHT$(filename$, 1)) = "S" THEN
daflag% = 1
sys% = 3
ELSE
daflag% = 0
sys% = 1 'Ampico
END IF

    GET #1, 33, Magic%
    IF Magic% <> 0 THEN 'old CIS file
	d$ = STRING$(40, 32)
	GET #1, 1, d$         ' Roll Title
    ELSE
	d$ = STRING$(32, 32)
	GET #1, 1, d$         ' Roll Title
	GET #1, , Magic% '       spare
	GET #1, , Statword% '    status word
	GET #1, , Vsep% '        twin array vertical separation
	GET #1, , Dpi% '         array dpi
	Sep% = Vsep%
	Stype% = (Statword% AND &HF)
	Sdbl% = (Statword% AND &H10) \ 16
	Twin% = (Statword% AND &H20) \ 32
	Bicol% = (Statword% AND &HC0) \ 64
	Div% = (Statword% AND &HF00) \ 256
    END IF
GET #1, , w%
GET #1, , cox%  'changeover between dual array days
GET #1, , tempo%
GET #1, , lpi%
GET #1, , ll&

PRINT : PRINT
PRINT "Filename        "; filename$
PRINT "Header string   "; d$
PRINT "Scanner width   "; w%
PRINT "Roll tempo      "; tempo%
PRINT "Scanner steps   "; lpi%
PRINT "Line count      "; ll&
PRINT
PRINT "Remember - this deletes previous .SCN file"
PRINT

PRINT
IF (tempo% < 40) OR (tempo% > 150) THEN BEEP: INPUT "Tempo "; tempo%
t% = 1'track on all notes

IF Magic% <> 0 THEN
   Stype% = 1
   GOTO SkipNewStuff
END IF
IF Stype% = 1 THEN 'free run scanner
   reallpi# = lpi%
ELSEIF Stype% = 2 THEN 'encoder data
  divreal% = 2 ^ Div%
  tpireal% = (lpi% / divreal%)
  'tpireal% = (100 / divreal%) 'fixed value because old data in CIS file
  lpilines& = (ll& / 4)
  PRINT "Calculating starting lpi."
  FOR x& = 1 TO lpilines&
    GOSUB getlinelpi
  NEXT x&
  SEEK #1, 53
  lpi% = (lpilines& / ecount&) * tpireal%
  lptstart% = lpi% / tpireal%
  FOR x% = 0 TO avstart%
    elc&(x%) = lptstart%
  NEXT x%
  PRINT "Starting lpi ="; lpi%
  'PRINT divreal%
  'PRINT tpireal%
  PRINT "Starting lpt="; lptstart%
  INPUT "Hit any key to start "; i$
END IF

SkipNewStuff:

avglpi# = lpi%
errtot# = 0 'reset tracking to centre
ctot% = 0

p% = 0
rr% = 0
ll% = 0
q% = 1
c% = 0
F% = 0
lc& = 0
ctot% = 1
chi% = 1
clo% = 1
zat& = 255
zan% = 255
m% = 2' initial display magnification
hs% = 0'initial display horiz shift
endflag% = 0
reallpi# = lpi%
'space# = (n99t% - n0t%) / 99
ec% = 0

'paper is 1 no paper is 0


SCREEN 9
VIEW PRINT 20 TO 23
'++++++++++++++++++++++++++++++++
df% = 2' display flag is off at start
top1:
GOSUB getkey

skip1:

GOSUB getline  ' returns with composite pixel image in array map%(x)
IF EOF(1) THEN GOTO finish
IF endflag% = 1 THEN GOTO finish
lc& = lc& + 1  ' increment line count

IF reallpi# <> 0 THEN lcnew# = lcnew# + lpi% / reallpi#
lcmod& = INT(lcnew# + .5)


'IF lc& < 200 THEN GOTO skip1 ' skip the first inch of the scan

'clear note array
FOR x% = 0 TO 101: notsbyte%(x%) = 0: NEXT

'find notes
'255 = hole ie note
x% = 0

WHILE x% < w%     ' step thro' pixel array

  IF map%(x%) = 0 THEN x% = x% + 1: GOTO skip4   ' skip if paper
  nc# = 0: c% = 0   ' we found a hole. Reset counters

loop3:
  c% = c% + 1    ' count hole width
nc# = nc# + x%   ' x% is pointer to start of hole, nc# will be pointer to end
  x% = x% + 1: IF x% > w% * 2 THEN GOTO skip4'end of line and still hole? quit
  IF map%(x%) <> 0 THEN GOTO loop3  ' keep counting
nf# = (nc# / c% - n0t%) / space# ' paper again, note value
 n% = nf#                          ' take integer of note value

IF (n% < 1) OR (n% > 65) THEN GOTO skip4   'skip garbage from edges of roll

'DuoArt fudge
'IF daflag% = 1 THEN
'damper pedal- DA damper pedal is at note 3.5 so it gets read as either 3 or 4
'IF n% = 3 THEN n% = 4
'themes - mix the themes onto one note number
'IF n% = 5 THEN n% = 6
'IF n% = 96 THEN n% = 95
'END IF

er# = (nf# - n%) * space# ' error in pixels difference between integer
			  ' and fractional values

IF n% > 0 THEN notsbyte%(n%) = 1
IF df% > 0 THEN PRESET (n% * 4, gy% + 155), 10'note integers

'++++++++++++++++++
'new tracking t%=1 is all notes, t%=2 is exp tracks only, t%=3 is no tracking
'Tracking options no longer required with 300 dpi arrays
'Set to track on all notes
IF t% = 3 THEN GOTO skip4 ' no tracking
'IF (n% < 7) OR (n% > 94) THEN GOTO skip4 'never read themes or DP for tracking,
					 'they are not on 9 to inch centres
					 'This only applies to DA but will not
					 'other rolls types.

IF t% = 1 THEN errtot# = errtot# + er#: ctot% = ctot% + 1: GOTO skip7' track on all notes (t%<> 2 or 3)
'IF (n% > 11) AND (n% < 90) THEN GOTO skip4'skip all but exp
errtot# = errtot# + er#: ctot% = ctot% + 1 ' errtot# is sum of errors
					   ' ctot% is count of errors
skip7:
IF ctot% < 25 THEN GOTO skip4    ' only adjust tracking after 25 errors terms
n0t% = n0t% + (errtot# / ctot%) / 2 ' add error terms to reference points
'n99t% = n99t% + (errtot# / ctot%) / 2
errtot# = 0: ctot% = 0              ' and reset

skip4:
WEND

'build scan file
FOR x% = 0 TO 101 ' note finder will have set or cleared slots in note array
IF notsbyte%(x%) = prev%(x%) THEN GOTO skip5'no change of state from previous pass

'+++++++++++++++++++++++++++++++++++++++++++++++++++
IF lcmod& < 1 THEN lcmod& = 1
PUT #2, , lcmod& ' record line num of change of state

IF notsbyte%(x%) = 1 THEN y% = (x% OR 128) ELSE y% = (x% AND 127)
PUT #2, , y%  ' and note value with bit 7 set if 'note on'
event1& = event1& + 1  ' increment event count
prev%(x%) = notsbyte%(x%)  ' update old record
skip5:
NEXT
skip6:
GOTO top1  ' end of main loop



finish:      'end sequence

    FOR x% = 0 TO 101
	IF notsbyte%(x%) = 1 THEN
	    PUT #2, , lcmod& ' record line num of change of state
	    y% = (x% AND 127)
	    PUT #2, , y%  ' and note value with bit 7 set if 'note on'
	    event1& = event1& + 1  ' increment event count
	END IF
    NEXT x%

e& = 1000000
x% = 0
sys% = 10
lpi% = avglpi#
lps = (lc& / rcount&) * 16 'lines per second
ips = lps / lpi%
PRINT "Ending Lpi="; lpi%; "Lps ="; lps; " Ips ="; ips; "Tempo ="; (ips / 12) * 600
INPUT "Hit any key to end "; i$
PUT #2, , e&             ' delimiter
PUT #2, , sys%           ' system number (e.g. Ampico ,DA etc)
PUT #2, , tempo%         ' roll tempo
PUT #2, , lpi%           ' scanner lines per inch
PUT #2, , x%             ' filler - spare slot
PUT #2, , event1&        ' number of events in file
CLOSE #1
CLOSE #2
'CLOSE #3

BEEP
PRINT filename$; " line Count ="; lc&
GOTO wayout


'##########################################

getlinelpi:
'Unpacks one line of pixel data from file and places it in map%(x)
cg% = 0: fl% = 0: p% = 0
gloop2lpi:
GET #1, , d%

IF EOF(1) THEN RETURN
gloopalpi:
cg% = cg% + d%
IF cg% = w% THEN GOTO gloop7lpi
GOTO gloop2lpi

gloop7lpi:
GET #1, , sbyte%  'read RTC (b5) and encoder(b7)
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'new bit 9 March 2003
e% = sbyte% AND 128
'
IF e% <> eold% THEN
 ecount& = ecount& + 1 'count changes of state of encoder
 eold% = e%
END IF

RETURN


'##########################################

getline:
'Unpacks one line of pixel data from file and places it in map%(x)
cg% = 0: fl% = 0: p% = 0
gloop2:
GET #1, , d%

IF EOF(1) THEN RETURN
gloopa:
IF cg% = w% THEN GOTO gloop7
IF d% = 0 THEN GOTO gloopb

map%(cg%) = fl%
cg% = cg% + 1:  d% = d% - 1
GOTO gloopa

gloopb:
fl% = fl% XOR 255

IF df% = 1 THEN PRESET (cg% / (2 * m%) + hs%, gy%), 10'notes skeletons

IF df% = 2 THEN
 IF (cg% > 50) AND (cg% < 340) THEN PRESET (cg% - 50, gy%), 10 'bass end
 IF (cg% < 3600) AND (cg% > 3310) THEN PRESET (cg% - 3310, gy%), 11'treble end
 IF gy% MOD 20 = 0 THEN FOR gg% = 0 TO 600 STEP 2: PRESET (gg%, gy%), 3: NEXT
END IF


p% = p% + 1': IF p% > 80 THEN RETURN
GOTO gloop2

gloop7:
GET #1, , sbyte%  'read RTC (b5) and encoder(b7)
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'new bit 9 March 2003
r% = sbyte% AND 32 '16 clock ticks per sec
IF r% <> rold% THEN
 rcount& = rcount& + 1'count changes of state of RTC
 rold% = r%
 lps = (lc& / rcount&) * 16 'lines per second
END IF

IF Stype% <> 2 THEN
  GOTO SkipEncoderFix
END IF

e% = sbyte% AND 128
'
IF e% <> eold% THEN
 'ecount& = ecount& + 1'count changes of state of encoder
 'IF ecount& < avstart% THEN av% = avstart% / 4 ELSE av% = avstart%
  av% = avstart%
 
 eold% = e%
 lpt% = lc& - lcold& 'lines per tick
 lcold& = lc&
 'average encoder counts
 IF lpt% <> 0 THEN
 elc&(ec%) = lpt%
 ec% = ec% + 1
 END IF

 
   IF ec% = av% THEN
   ec% = 0
   END IF
   ec2% = 0
   elctot& = 0
   FOR x% = 0 TO av%
   elctot& = elctot& + elc&(x%): ec2% = ec2% + 1
   NEXT
   lptav# = elctot& / (ec2% - 1)
   'END IF
   reallpi# = lptav# * tpireal%
   avglpi# = (avglpi# + reallpi#) / 2
   'WRITE #3, lc&, lptav#, reallpi#
   'IF ecount& = 0 THEN reallpi# = lpi%
   'IF ecount& = 1 THEN reallpi# = lpt% * 100'4
   END IF

SkipEncoderFix:

'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
IF lc& > 401 AND lc& MOD 200 = 0 THEN
PRINT filename$;
'IF daflag% = 0 THEN PRINT " Not DA"; :  ELSE PRINT " DA or Std";
PRINT " LL="; ll&; " LC="; lc&; " LCmod&"; lcmod&; " Real lpi="; INT(reallpi#); " N0="; INT(n0t%);
IF df% = 0 THEN PRINT "Disp off":  ELSE PRINT

'add tempo correction display
IF lc& > 0 THEN hp = lc& / ll&
PRESET (600 * hp, lptav# * 2.5 + 20), 11'
'PRESET (600 * hp, INT(iips * 800) - 490), 12
'PRESET (600 * hp, (lpt% * 25) / 10), 10
END IF
IF df% = 0 THEN RETURN

IF df% = 1 THEN
'draw guidelines down screen
  FOR gg% = 0 TO 100: PRESET ((n0t% + gg% * space#) / (2 * m%) + hs%, gy%), 3: NEXT'grid lines
   PRESET ((n0t% + 4 * space#) / (2 * m%) + hs%, gy%), 5'other dp marker

  PRESET ((n0t% + 99 * space#) / (2 * m%) + hs%, gy%), 4'SP marker
  'display status byte
  PRESET (r% / 8, gy%), 12
  PRESET (e% / 32 + 10, gy%), 13
END IF

'DA expression track markers remmed out in this version
IF gy% MOD 20 = 0 THEN
 PRESET (16, gy% + 150), 12'dp marker
 PRESET (396, gy% + 150), 12'sp marker
' PRESET (24, gy% + 150), 12'bt marker
' PRESET (380, gy% + 150), 12'tt marker
' PRESET (28, gy% + 150), 11'acc marker
' PRESET (32, gy% + 150), 11'acc marker
' PRESET (36, gy% + 150), 11'acc marker
' PRESET (40, gy% + 150), 11'acc marker
' PRESET (364, gy% + 150), 11'thm marker
' PRESET (368, gy% + 150), 11'thm marker
' PRESET (372, gy% + 150), 11'thm marker
' PRESET (376, gy% + 150), 11'thm marker
END IF

gy% = gy% + 1
IF gy% > 150 THEN
waitflag = 1
WHILE waitflag = 1
GOSUB getkey
IF endflag% = 1 THEN GOTO finish
IF ik$ <> "" THEN waitflag = 0
WEND
CLS 1: gy% = 0
END IF

RETURN

getkey:
ik$ = INKEY$
'set parameters for various display options
IF ik$ = CHR$(27) THEN endflag% = 1
IF ik$ = CHR$(32) THEN df% = 1
IF ik$ = CHR$(13) THEN df% = 0

IF ik$ = "z" THEN df% = 1: hs% = 0: m% = 1
IF ik$ = "x" THEN df% = 1: hs% = 0: m% = 3
IF ik$ = "c" THEN df% = 1: hs% = -1200: m% = 1
IF ik$ = "a" THEN df% = 2
RETURN

wayout:
END SUB

