/*
	RS1PP.H

	RollSCAN-1 Parallel Port Access - Definitions
*/
#include <windows.h>

/* Defines */

#define	RS1_SUCCESS	TRUE
#define RS1_FAILURE	FALSE

#define PP_DREGOFS 0
#define PP_SREGOFS 1
#define PP_CREGOFS 2
#define PP_EPPADDR 3
#define PP_EPPDATA 4
#define PP_ECPECR 0x402

#define PP_EPPTIMEOUT 1

#define PMODE_SPP 0
#define PMODE_PS2 1
#define PMODE_EPP 2
#define PMODE_EPP16 3
#define PMODE_EPP32 4
#define PMODE_ECPasPS2 8
#define PMODE_ECPasEPP 9
#define PMODE_ECPasEPP16 10
#define PMODE_ECPasEPP32 11


/* Parallel Port Functions */

BOOL RS1PP_SelectPort(int portnum);
BOOL RS1PP_SetPortBase(WORD baseaddr);
WORD RS1PP_GetPortBase(void);
void RS1PP_SetPortMode(BYTE mode);
WORD RS1PP_GetPortMode(void);
BOOL PortInitCheck(void);
void RS1Ctlr_Reset(void);
void RS1Ctlr_Wake(void);
void RS1Ctlr_Silence(void);
BOOL RS1Ctlr_Init(void);
BOOL RS1Ctlr_RamTest(void);

BOOL RS1Ctlr_EppWAddr(BYTE Addr);
BOOL RS1Ctlr_SppWAddr(BYTE Addr);
BOOL RS1Ctlr_EppWData(BYTE data);
BOOL RS1Ctlr_SppWData(BYTE data);
BOOL RS1Ctlr_SppWDataReg(BYTE regadr, BYTE data);
BOOL RS1Ctlr_EppWDataReg(BYTE regadr, BYTE data);;
BOOL RS1Ctlr_EppRData(BYTE *data);
BOOL RS1Ctlr_PS2RData(BYTE *data);
BOOL RS1Ctlr_SppRData(BYTE *data);
BOOL RS1Ctlr_SppRDataReg(BYTE regadr, BYTE *data);
BOOL RS1Ctlr_PS2RDataReg(BYTE regadr, BYTE *data);
BOOL RS1Ctlr_EppRDataReg(BYTE regadr, BYTE *data);
BOOL RS1Ctlr_WriteRegs(DWORD n, BYTE *reglist, BYTE *regdata);
BOOL RS1Ctlr_ReadRegs(DWORD n, BYTE *reglist, BYTE *regdata);
BOOL RS1Ctlr_WriteBlockData(DWORD n, BYTE regadr, BYTE *data);
BOOL RS1Ctlr_ReadBlockData(DWORD n, BYTE regadr, BYTE *data);


BOOL RS1Ctlr_WriteRegAddr(BYTE regadr);
BOOL RS1Ctlr_WriteData(BYTE data);
BOOL RS1Ctlr_WriteDataToReg(BYTE regadr, BYTE data);
BOOL RS1Ctlr_ReadData(BYTE *data);
BOOL RS1Ctlr_ReadDataFromReg(BYTE regadr, BYTE *data);
BOOL RS1Ctlr_WriteRegs(DWORD n, BYTE *reglist, BYTE *regdata);
BOOL RS1Ctlr_ReadRegs(DWORD n, BYTE *reglist, BYTE *regdata);
BOOL RS1Ctlr_WriteBlockData(DWORD n, BYTE regadr, BYTE *data);
BOOL RS1Ctlr_ReadBlockData(DWORD n, BYTE regadr, BYTE *data);

/* Enumerate and Test Functions */

int RS1_EnumeratePorts(WORD *paddr, int *ptype);
int RS1_FindPortType(WORD base);
BYTE ECP_EcrRead(base);
void ECP_EcrWrite(WORD base, BYTE data);
BYTE ControlPortRead(WORD base);
void ControlPortWrite(WORD base, BYTE data);
BOOL TestForEcp(WORD base);
int ReadEppTimeoutBit(base);
BOOL TestForEpp(WORD base);
BOOL TestForPS2(WORD base);
BOOL TestForSpp(WORD base);	
int GetEcpMode(base);

#define RS1_NOPORT 0
#define RS1_SPP 0x100
#define RS1_PS2 0x200
#define RS1_EPP 0x300
#define RS1_ECP 0x400

